from sandbox.projects.images import responses as images_responses
from sandbox.projects.images.metasearch import task as metasearch_task


OUT_RESOURCE_KEY = 'out_resource_id'
STATS_KEY = 'stats'


class ImagesGetMetasearchResponses(images_responses.ResponsesTask,
                                   metasearch_task.BaseMetasearchTask):
    """
        Get search responses via middle and intermediate layers
    """

    type = 'IMAGES_GET_METASEARCH_RESPONSES'
    execution_space = 150000

    input_parameters = \
        metasearch_task.BaseMetasearchTask.input_parameters + \
        images_responses.ResponsesTask.input_parameters

    def on_enqueue(self):
        metasearch_task.BaseMetasearchTask.on_enqueue(self)
        self._create_responses_resource(OUT_RESOURCE_KEY)

    def _use_components(self, basesearch, snippetizer, intsearch, middlesearch):
        self._get_responses(middlesearch, OUT_RESOURCE_KEY, STATS_KEY)


__Task__ = ImagesGetMetasearchResponses
