from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import process

from sandbox.projects import resource_types
from sandbox.projects.common import dolbilka
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common import utils
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.images.metasearch import task as metasearch_task
from sandbox.common.types.client import Tag


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    group = dolbilka.DOLBILKA_GROUP
    resource_type = (resource_types.IMAGES_MIDDLESEARCH_PLAN, resource_types.BASESEARCH_PLAN)
    required = True


class CustomBanParameter(parameters.ResourceSelector):
    name = 'custom_ban_resource_id'
    description = 'Custom ban'
    resource_type = media_settings.ImagesSettings.middlesearch_data_resources(media_settings.INDEX_MIDDLE)
    required = False


class ImagesTestMiddlesearchPerformance(search_performance.OldShootingTask, metasearch_task.BaseMiddlesearchTask):
    """
        Benchmark middlesearch over basesearch and snippetizer
    """

    type = 'IMAGES_TEST_MIDDLESEARCH_PERFORMANCE'

    client_tags = search_performance.OldShootingTask.client_tags & metasearch_task.BaseMiddlesearchTask.client_tags & Tag.SSD

    execution_space = 160 * 1024

    shoot_input_parameters = \
        (PlanParameter, CustomBanParameter) + \
        search_performance.OldShootingTask.shoot_input_parameters

    input_parameters = \
        metasearch_task.BaseMiddlesearchTask.input_parameters + \
        shoot_input_parameters

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        if "max_rps" in self.ctx:
            return "{:0.2f}".format(self.ctx["max_rps"])

    def on_execute(self):
        self._ensure_custom_ban(utils.get_or_default(self.ctx, CustomBanParameter))
        metasearch_task.BaseMiddlesearchTask.on_execute(self)

    def _get_queries_parameter(self):
        return PlanParameter

    def init_search_component(self, middlesearch):
        middlesearch.disable_cache()

    def _get_middlesearch(self):
        middlesearch = metasearch_task.BaseMiddlesearchTask._get_middlesearch(self)
        self.init_search_component(middlesearch)
        return middlesearch

    def _use_components(self, basesearch, snippetizer, intsearch, middlesearch):
        self._vmtouch_search_database()
        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        self._old_shoot(middlesearch, self.ctx[PlanParameter.name])

    def _vmtouch_search_database(self):
        # TODO: Should we also try to touch middlesearch index and data?
        # TODO: Don't touch archive
        database_resource_list = (
            metasearch_task.BASESEARCH_PARAMS.Database,
            metasearch_task.SNIPPETIZER_PARAMS.Database,
        )
        for database_resource_param in database_resource_list:
            database_resource_id = self.ctx[database_resource_param.name]
            database_resource_path = self.sync_resource(database_resource_id)
            process.run_process(
                ["vmtouch", "-tv", database_resource_path],
                outputs_to_one_file=False,
                log_prefix="vmtouch"
            )


__Task__ = ImagesTestMiddlesearchPerformance
