from sandbox.projects.common import sanitizer
from sandbox.projects.common.search import components as search_components
from sandbox.projects.images.metasearch import ImagesTestMiddlesearchPerformance as performance_task


_BASE_CLASS = sanitizer.generate_task(
    search_components.DefaultMiddlesearchParams,
    performance_task.ImagesTestMiddlesearchPerformance,
    start_timeout=search_components.DEFAULT_START_TIMEOUT * 4
)


class ImagesTestMiddlesearchSanitizer(_BASE_CLASS, object):
    type = 'IMAGES_TEST_MIDDLESEARCH_SANITIZER'

    def init_search_component(self, component, wrap_symbolizer=0):
        self.ctx["san_env_options"] = "allocator_may_return_null=1"
        super(ImagesTestMiddlesearchSanitizer, self).init_search_component(component, wrap_symbolizer)


__Task__ = ImagesTestMiddlesearchSanitizer
