import sandbox.common.types.misc as ctm

from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types
from sandbox.projects.common import dolbilka
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common import utils
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import yasm as search_yasm
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.images.metasearch import task as metasearch_task


_INSTANCE_TYPE = "mmeta"
_INSTANCE_TAG = (
    ("ctype", "prod"),
    ("geo", "msk"),
    ("prj", "imgs-main"),
    ("tier", "yandsearch"),
)


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    group = dolbilka.DOLBILKA_GROUP
    resource_type = (resource_types.IMAGES_MIDDLESEARCH_PLAN, resource_types.BASESEARCH_PLAN)
    required = True


class CustomBanParameter(parameters.ResourceSelector):
    name = 'custom_ban_resource_id'
    description = 'Custom ban'
    resource_type = media_settings.ImagesSettings.middlesearch_data_resources(media_settings.INDEX_MIDDLE)
    required = False


class ImagesTestMiddlesearchUnistat(search_performance.OldShootingTask,
                                    search_yasm.YasmAgentTask,
                                    metasearch_task.BaseMiddlesearchTask):
    """
        Verify unistat implementation in middlesearch
    """

    type = "IMAGES_TEST_MIDDLESEARCH_UNISTAT"

    shoot_input_parameters = \
        (PlanParameter, CustomBanParameter) + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        search_yasm.YasmAgentTask.input_parameters

    input_parameters = \
        metasearch_task.BaseMiddlesearchTask.input_parameters + \
        shoot_input_parameters

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        if "max_rps" in self.ctx:
            return "{:0.2f}".format(self.ctx["max_rps"])

    def on_enqueue(self):
        metasearch_task.BaseMiddlesearchTask.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            resource_types.BASESEARCH_UNISTAT_SIGNALS,
            arch=ctm.OSFamily.ANY
        )

    def on_execute(self):
        self._ensure_custom_ban(utils.get_or_default(self.ctx, CustomBanParameter))
        metasearch_task.BaseMiddlesearchTask.on_execute(self)

    def _get_queries_parameter(self):
        return PlanParameter

    def init_search_component(self, middlesearch):
        middlesearch.disable_cache()

    def _get_middlesearch(self):
        middlesearch = metasearch_task.BaseMiddlesearchTask._get_middlesearch(self)
        self.init_search_component(middlesearch)
        return middlesearch

    def _use_components(self, basesearch, snippetizer, intsearch, middlesearch):
        yasmagent = self._yasmagent(middlesearch, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        with yasmagent, yasmlistener:
            self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
            self._old_shoot(middlesearch, self.ctx[PlanParameter.name])
        yasmlistener.dump(self.__unistat_signals())

    def _after_components(self, basesearch, snippetizer, intsearch, middlesearch):
        pass

    def _set_yasm_config_options(self, config_object):
        config_object.set("options_unistat", "url", "/tass?level=20&allholes=1")

    def __unistat_signals(self):
        return self.abs_path("unistat-signals.txt")


__Task__ = ImagesTestMiddlesearchUnistat
