from sandbox.sandboxsdk import channel
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import task

from sandbox.projects.websearch.middlesearch import PriemkaMiddlesearchBinary as priemka_task
from sandbox.projects.websearch.middlesearch.PriemkaMiddlesearchBinary import params as priemka_params
from sandbox.projects.common import utils
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.images.models import ImagesBuildDynamicModels as build_task


_BUILD_TASK_ID = 'build_task_id'
_TEST_TASK_ID = 'test_task_id'


class ImagesPriemkaMiddlesearchModels(task.SandboxTask):
    """
        Builds models and run tests to verify them
    """

    type = 'IMAGES_PRIEMKA_MIDDLESEARCH_MODELS'

    input_parameters = []

    @property
    def footer(self):
        task_types = [
            (_BUILD_TASK_ID, "Build task"),
            (_TEST_TASK_ID, "Test task")
        ]

        for key, title in task_types:
            if key not in self.ctx:
                return "Initializing..."

        return {
            "content": {
                "header": [
                    {"key": "task", "title": "&nbsp;"},
                    {"key": "status", "title": "&nbsp;"}
                ],
                "body": {
                    "task": [
                        "<a href='/task/{}/view'>{}</a>".format(self.ctx[key], title)
                        for key, title in task_types
                    ],
                    "status": [
                        utils.colored_status(channel.channel.sandbox.get_task(self.ctx[key]).status)
                        for key, title in task_types
                    ]
                }
            }
        }

    def on_execute(self):
        if _BUILD_TASK_ID not in self.ctx:
            build_task_id, new_models_resource_id = self._build_models()
            old_models_resource_id = self.__get_old_models_resource_id()

            self.ctx[_TEST_TASK_ID] = self._test_models(old_models_resource_id, new_models_resource_id)
            self.ctx[_BUILD_TASK_ID] = build_task_id

        utils.check_subtasks_fails(fail_on_first_failure=True)

    def _build_models(self):
        sub_ctx = {
            build_task.IndexTypeParameter.name: search_settings.INDEX_MIDDLE,
            build_task.ModelsTypeParameter.name: self.__get_models_type(),
        }
        sub_task = self.create_subtask(
            task_type=build_task.ImagesBuildDynamicModels.type,
            input_parameters=sub_ctx,
            description=self.descr,
        )
        return sub_task.id, sub_task.ctx[build_task.OUT_RESOURCE_KEY]

    def _test_models(self, old_models_resource_id, new_models_resource_id):
        sub_ctx = {
            priemka_params.BinType.name: "img",
            priemka_params.AcceptanceType.name: priemka_params.AcceptanceType.MODELS_ACCEPTANCE,
            priemka_params.CTX_LEVEL_TEMPLATE.format("int"): False,
            priemka_params.TestsToRun.TestResponses.name: False,
            priemka_params.TestsToRun.TestMemoryUsage.name: False,  # Enable after fixing problems with GET_MIDDLESEARCH_RESOURCES task
            priemka_params.SOURCE_TEMPLATE.format("models", "old", "mmeta"): priemka_params.SourceType.SPECIFIED,
            priemka_params.RESOURCE_TEMPLATE.format("models", "old", "mmeta"): old_models_resource_id,
            priemka_params.SOURCE_TEMPLATE.format("models", "new", "mmeta"): priemka_params.SourceType.SPECIFIED,
            priemka_params.RESOURCE_TEMPLATE.format("models", "new", "mmeta"): new_models_resource_id,
        }
        sub_task = self.create_subtask(
            task_type=priemka_task.PriemkaMiddlesearchBinary.type,
            input_parameters=sub_ctx,
            description=self.descr,
        )
        return sub_task.id

    def __get_old_models_resource_id(self):
        return utils.get_and_check_last_released_resource_id(
            search_settings.ImagesSettings.models_resource(search_settings.INDEX_MIDDLE, self.__get_models_type()),
            arch=sandboxapi.ARCH_LINUX
        )

    def __get_models_type(self):
        return search_settings.MODELS_PRODUCTION


__Task__ = ImagesPriemkaMiddlesearchModels
