import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import errors
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import paths

from sandbox.projects import resource_types

from sandbox.projects.common.base_search_quality import response_saver
from sandbox.projects.common.dynamic_models import archiver as archiver_models
from sandbox.projects.common.dynamic_models import basesearch as basesearch_models
from sandbox.projects.common.dynamic_models import matrixnet as matrixnet_models
from sandbox.projects.common.search import requester_compat as search_requester
from sandbox.projects.images.metasearch import task as metasearch_task
from sandbox.projects.images.resources import task as resources_task


RESPONSE_SAVER_PARAMS = response_saver.create_response_saver_params(required_queries=False)


class MaxModelsNumberParameter(parameters.SandboxIntegerParameter):
    name = 'models_max_number'
    description = 'Max models number'
    default_value = 100


class ImagesTestMiddlesearchModels(resources_task.ImagesProductionResourcesTask, metasearch_task.BaseMiddlesearchTask):
    """
        Test that basesearch recognize archive correctly
    """

    type = 'IMAGES_TEST_MIDDLESEARCH_MODELS'
    client_tags = ctc.Tag.LINUX_PRECISE
    input_parameters = \
        (MaxModelsNumberParameter,) + \
        metasearch_task.BaseMiddlesearchTask.input_parameters + \
        RESPONSE_SAVER_PARAMS.params + \
        search_requester.create_params()

    execution_space = 150 * 1024  # 150 Gb

    def _get_queries_parameter(self):
        class _FakeParameter:
            name = 'fake_parameter'
        return _FakeParameter

    def _use_components(self, basesearch, snippetizer, intsearch, middlesearch):
        queries_path = "queries.txt"
        responses_path = "responses.txt"
        model_ids = self.__get_model_ids(self.ctx[metasearch_task.MIDDLESEARCH_PARAMS.ArchiveModel.name])
        basesearch_models.create_plain_text_queries(model_ids, self.descr, queries_path)

        middlesearch.use_component(lambda: search_requester.save_responses_old(self.ctx, queries_path, responses_path, middlesearch))

        basesearch_models.verify_basesearch_responses("responses.txt", model_ids)
        self.set_info('{} formulas checked'.format(len(model_ids)))
        self.create_resource("{}, responses".format(self.descr), responses_path, resource_types.OTHER_RESOURCE)

    def __get_model_ids(self, archive_id):
        models_dir = "models"
        paths.make_folder("models", delete_content=True)
        archiver_models.unpack(
            self.sync_resource(self._get_archiver_executable()),
            self.sync_resource(archive_id),
            models_dir
        )
        models_ids = list(matrixnet_models.get_models_id(self.sync_resource(self._get_mx_ops_executable()), [models_dir]))
        max_models = self.ctx[MaxModelsNumberParameter.name]
        if len(models_ids) > max_models:
            raise errors.SandboxTaskFailureError("Too many models ({} > {})".format(len(models_ids), max_models))
        return [v for k, v in models_ids]


__Task__ = ImagesTestMiddlesearchModels
