from sandbox import sdk2


class ModelsResource(sdk2.Resource):
    """
        Base class for dynamic models
    """
    __default_attribute__ = sdk2.parameters.String

    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = ['nerevar', 'robot-images-sandbox', 'gilazhev', 'anskor', 'ivankol', 'krivokon', 'pupatenko']


class IMAGES_BASESEARCH_EXP_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images basesearch (experimental)
    """
    pass


class IMAGES_BASESEARCH_PROD_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images basesearch (production)
    """
    pass


class IMAGES_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images basesearch (experimental + production)
    """
    pass


class IMAGES_MIDDLESEARCH_EXP_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images middlesearch (experimental)
    """
    pass


class IMAGES_MIDDLESEARCH_PROD_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images middlesearch (production)
    """
    pass


class IMAGES_MIDDLESEARCH_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images middlesearch (experimental + production)
    """
    pass


class IMAGES_L1_DYNAMIC_MODELS_ARCHIVE(ModelsResource):
    """
        Dynamic models for images l1 intsearch (experimental + production)
    """
    pass
