from sandbox import sdk2
from sandbox.projects import resource_types


class ImagesPolishResource(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.images_releasers


class ImagesPolishToolResource(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_types.images_releasers
    images_subscribers = ['images-releases']


class IMAGES_MANUAL_BOOSTING_VERSION(ImagesPolishResource):
    """
        Manual boosting data version (semidups state)
    """
    basename = 'manual_boosting.version'


class IMAGES_MANUAL_BOOSTING_SHARD_TS(ImagesPolishResource):
    """
        Manual boosting timestamp of shard
    """
    basename = 'manual_boosting.shard_ts'


class IMAGES_MANUAL_BOOSTING_SAS_TS(ImagesPolishResource):
    """
        Manual boosting timestamp of shard, released after SAS
    """
    basename = 'manual_boosting.sas_ts'


class IMAGES_MANUAL_BOOSTING_FINAL_TS(ImagesPolishResource):
    """
        Manual boosting timestamp of shard, released after all
    """
    basename = 'manual_boosting.final_ts'


class IMAGES_MANUAL_BOOSTING(ImagesPolishToolResource):
    """
        Utility to manage attractivity data
    """
    arcadia_build_path = 'extsearch/images/tools/manual_boosting'


class SAAS_STANDALONE_INDEXER(ImagesPolishToolResource):
    """
        Utility to boil shard of SaaS
    """
    arcadia_build_path = 'saas/tools/standalone_indexer'


class SAAS_IMAGES_BUFFING_RTY_CONFIG(ImagesPolishToolResource):
    """
        configs/rtyserver.conf-common of SaaS service images-buffing
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class SAAS_IMAGES_BUFFING_SEARCH_MAP(ImagesPolishToolResource):
    """
        configs/searchmap.json of SaaS service images-buffing
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
