import os.path
import platform

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import paths
from sandbox.sandboxsdk import parameters
# from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import task

from sandbox.projects.images.prism import resources


PYTHON_PACKAGES = ["pip", "matplotlib", "yasmapi", "numpy"]


class ArcadiaUrl(parameters.SandboxArcadiaUrlParameter):
    name = "arcadia_url"
    description = 'Arcadia url'
    default_value = svn.Arcadia.trunk_url("sandbox/projects/images/prism/tools")
    required = True


class ImagesBuildPrismVirtualenv(task.SandboxTask):
    """
    Build virtual environment for yandex tank
    """

    type = "IMAGES_BUILD_PRISM_VIRTUALENV"
    client_tags = ctc.Tag.LINUX_PRECISE
    input_parameters = (ArcadiaUrl,)

    def on_execute(self):
        archive_name = 'images-prism-virtualenv.tar.gz'
        with environments.VirtualEnvironment() as venv:
            for python_package in PYTHON_PACKAGES:
                venv.pip(python_package)

            prism_dir = os.path.join(venv.root_dir, "prism")
            paths.make_folder(prism_dir)
            svn.Arcadia.export(self.ctx[ArcadiaUrl.name], prism_dir)

            venv.pack_bundle(archive_name)

        self.create_resource(
            description=self.descr,
            resource_path=archive_name,
            resource_type=resources.IMAGES_PRISM_VIRTUALENV,
            attributes={'platform': platform.platform()},
        )


__Task__ = ImagesBuildPrismVirtualenv
