from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common.search.settings import ImagesSettings
from sandbox.projects.common.pumpkin import index_task
from sandbox.projects.common.mediasearch import yasm_task
from sandbox.projects.images.pumpkin import resources as images_pumpkin_resources


_IMAGES_MR_COLLECTOR_ARGS = ('-t', 'images', '-a', '-c', '-P', '15', '-F', '0.2')  # Standard set of parameters

_IMAGES_MR_USER = "sepe"
_IMAGES_MR_SERVER = "hahn.yt.yandex.net"
_IMAGES_MR_TABLE_PREFIX = "home/sepe/images-pumpkin/"

_EXECUTED_KEY = "_task_executed"


class StartDateParameter(parameters.SandboxStringParameter):
    name = 'start_date'
    description = 'Start date'
    required = False


class DevelopmentModeParameter(parameters.SandboxBoolParameter):
    name = 'development_mode'
    description = 'Development mode'
    default_value = True
    sub_fields = {
        'true': [
            index_task.MrUserParameter.name,
            index_task.MrServerParameter.name
        ]
    }


# NOTE: There is a minor difference in UILanguageParameter meaning for web and for images
# While in web it's a UI setting in images it corresponds to tld
class ImagesBuildPumpkinIndex(yasm_task.YasmTask, index_task.BaseBuildPumpkinIndexTask):
    type = "IMAGES_BUILD_PUMPKIN_INDEX"

    input_parameters = (
        StartDateParameter,
        DevelopmentModeParameter,
    ) + index_task.BaseBuildPumpkinIndexTask.input_parameters

    INDEX_RESOURCE_TYPE = images_pumpkin_resources.IMAGES_PUMPKIN_INDEX
    ARCHIVE_RESOURCE_TYPE = images_pumpkin_resources.IMAGES_PUMPKIN_INDEX_ARCHIVE

    def on_enqueue(self):
        index_task.BaseBuildPumpkinIndexTask.on_enqueue(self)
        channel.task = self

        attributes = {}
        if not self.ctx[DevelopmentModeParameter.name]:
            production_attributes = ImagesSettings.pumpkin_resource_attributes(self.ctx[index_task.UILanguageParameter.name])
            attributes[production_attributes[0]] = production_attributes[1]
            self.ctx[index_task.MrUserParameter.name] = _IMAGES_MR_USER
            self.ctx[index_task.MrServerParameter.name] = _IMAGES_MR_SERVER

        if not self.ctx[index_task.MrTableParameter.name]:
            self.ctx[index_task.MrTableParameter.name] = _IMAGES_MR_TABLE_PREFIX + self.ctx[index_task.UILanguageParameter.name]

        self._make_resources(attributes)

    def on_execute(self):
        # yasm_notify can raise TemporaryError, so we need to avoid a double work
        if _EXECUTED_KEY not in self.ctx:
            collector_args = _IMAGES_MR_COLLECTOR_ARGS
            start_date = self.ctx.get(StartDateParameter.name)
            if start_date:
                collector_args += ('-d', start_date)

            collector_cmd = self._make_collector_cmd(collector_args)
            self._build_index(collector_cmd, {"RemoveImageMarkers": "1"})
            self.ctx[_EXECUTED_KEY] = 1

        ui_language = self.ctx[index_task.UILanguageParameter.name]
        self._yasm_notify(push_signal_name="build_pumpkin_index_{}".format(ui_language))


__Task__ = ImagesBuildPumpkinIndex
