# -*- encoding: utf-8 -*-
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

import resources as resource_types


class ImagesUpdateQuentao(BaseMediaBuildTask):
    '''
        Обновить картиночные светофоры.
    '''

    type = "IMAGES_UPDATE_QUENTAO"
    execution_space = 60000

    def get_binaries(self):
        return (
            resource_types.IMAGES_QUENTAO
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_QUENTAO_PANEL,
            resource_types.IMAGES_QUENTAO_ALERTS
        )

    def on_execute(self):
        BaseMediaBuildTask.on_execute(self)

        binary_path = ""
        panel_path = ""
        alerts_path = ""

        task_resources = sdk2.Resource.find(task_id=self.id).limit(1000)
        for resource in task_resources:
            res = sdk2.Resource[resource.id]
            if res.type == resource_types.IMAGES_QUENTAO:
                binary_path = str(sdk2.ResourceData(res).path)
            if res.type == resource_types.IMAGES_QUENTAO_PANEL:
                panel_path = str(sdk2.ResourceData(res).path)
            if res.type == resource_types.IMAGES_QUENTAO_ALERTS:
                alerts_path = str(sdk2.ResourceData(res).path)

        if binary_path == "" or panel_path == "" or alerts_path == "":
            raise SandboxTaskFailureError("Error empty resources")

        args = [binary_path, 'upload', '--panel-file', panel_path, '--alerts-file', alerts_path]
        if subprocess.Popen(args, stderr=subprocess.STDOUT).wait() != 0:
            raise SandboxTaskFailureError("Error fail binary")


__Task__ = ImagesUpdateQuentao
