# -*- encoding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class IMAGES_QUENTAO(sdk2.resource.AbstractResource):
    """
        Исполняемый файл для обновления картиночной панели светофоров
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True
    releasers = get_current_images_devops('panovav', 'robot-images-sandbox')
    release_subscribers = ['images-releases', 'panovav']
    arcadia_build_path = 'extsearch/images/tools/quentao/quentao'


class IMAGES_QUENTAO_PANEL(sdk2.resource.AbstractResource):
    """
       json с картиночной панелью светофоров
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = True
    releasers = get_current_images_devops('panovav', 'robot-images-sandbox')
    release_subscribers = ['images-releases', 'panovav']
    arcadia_path = 'extsearch/images/tools/quentao/panel.json'


class IMAGES_QUENTAO_ALERTS(sdk2.resource.AbstractResource):
    """
       json с картиночными алертами
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = True
    releasers = get_current_images_devops('panovav', 'robot-images-sandbox')
    release_subscribers = ['images-releases', 'panovav']
    arcadia_path = 'extsearch/images/tools/quentao/alerts.json'
