from sandbox import sdk2


images_quick_releasers = [
    'ulgen4a',
    'sakhnov',
    'anskor',
    'fexion',
    'igorluk',
    'ivankol',
    'robot-images-sandbox',
    'robot-testenv',
    'evseevd',
    'kozlovkr',
    'gritsaev',
    'foxxmary',
    'mrboogie',
    'wwfq',
]


images_quick_subscribers = images_quick_releasers + ['ak762']


class ImagesQuickdaemonResource(sdk2.Resource):
    auto_backup = True
    releasers = images_quick_releasers
    release_subscribers = images_quick_subscribers


class IMAGES_QUICKDAEMON_LOOP_CONFIG(ImagesQuickdaemonResource):
    """
      Configuration file for instancectl - quickdaemon
    """
    releasable = True
    arcadia_path = 'extsearch/images/daemons/quickdaemon/prod_configs/loop.conf'


class IMAGES_QUICK_PACKAGE(ImagesQuickdaemonResource):
    """
      Package for quickdaemon services
    """
    releasable = True
