# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops

# Releasers

images_index_releasers = [
    'anskor',
    'igorluk',
    'robot-images-sandbox',
    'sakhnov',
    'ulgen4a',
    'fexion',
    'ivankol',
    'gritsaev',
    'robot-testenv',
    'evseevd',
    'krylov-sergey',
    'kozlovkr',
    'foxxmary',
    'mrboogie',
    'ololowl',
    'wwfq',
]

images_rim_releasers = [
    'pupatenko',
    'krivokon',
    'kapacek'
]


# Subscribers

images_subscribers = ['images-releases']
images_mrindex_subscribers = images_subscribers + ['images-index']
images_rim_subscribers = ['images-rim']

images_releasers = [
    'krivokon',
    'fedorenko',
    'gilazhev',
    'pupatenko',
    'ivankol',
    'sind',
    'gritsaev',
    'yudapav',
    'krylov-sergey',
    'kapacek'] + images_index_releasers


class IMAGES_RELEASE_RESOURCES_EXECUTABLE(sdk2.Resource):
    """
        Resources release binary, images robot
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers + images_rim_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/release_resources/release_resources'


class IMAGES_INDEX_UPDATE_ANALYST(sdk2.Resource):
    """
        Исполняемый файл для анализа апдейтов документов в индексе
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/update_analyst/update_analyst'


class IMAGES_CALLISTO_HELPER(sdk2.Resource):
    """
        Исполняемый файл для управления выгрузкой индекса через callisto
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/callisto_helper/callisto_helper'


class IMAGES_RIMDB_SERPS_COMPARE(sdk2.Resource):
    """
       Rim DB serps compare tool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    release_subscribers = images_rim_subscribers
    arcadia_build_path = 'extsearch/images/tools/nirvana/rim/serps_compare/rim_serps_compare'


class IMAGES_RIMDB_LEARN(sdk2.Resource):
    """
       Learning tool for RIM DB
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    release_subscribers = images_rim_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/learn/rim_learn'


class IMAGES_MONEY_ROBOT_PACKAGE(sdk2.Resource):
    """
       Money robot package
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_MONEY_DOWNLOAD_MARKET_FROM_AWAPS_BINARY(sdk2.Resource):
    """
       Исполняемый файл для скачивания маркетной выгрузки из awaps
    """
    releasable = True
    releasers = images_releasers + ['robot-images-money']


class IMAGES_MONEY_PBSNCAT_BINARY(sdk2.Resource):
    """
       Исполняемый файл pbsncat
    """
    releasable = True
    releasers = images_releasers + ['robot-images-money']


class IMAGES_ONTOSEARCH_ROBOT_PACKAGE(sdk2.Resource):
    """
       Ontosearch robot package
    """
    releasable = True
    releasers = images_releasers + ['robot-img-ontosearch']


class IMAGES_FACTORS_CLEAN_STATES(sdk2.Resource):
    """
       Исполняемый файл для очистки стейтов factordb.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/factordb_clean_states/factordb_clean_states'


class IMAGES_MR_INDEX_HOSTFACTORS_STATISTICS(sdk2.Resource):
    """
       Исполняемый файл для подсчета статистики по внешним таблицам с хостовыми факторами.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/statistics/hostfactors/hostfactors_statistics'


class IMAGES_RTCVDUP_CONVERT_SNAPSHOT(sdk2.Resource):
    """
       Executable to convert rtcvdup snapshot to semidups-compatible state format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/rtcvdup/tools/convert/rtcvdup-convert-snapshot'


class IMAGES_SAMSUNG_MARKET_API_CHECKER(sdk2.Resource):
    """
       Исполняемый файл для проверки
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    release_subscribers = []


class IMAGES_RAW_REQUESTS(sdk2.Resource):
    releasable = False
    auto_backup = True
    collection = sdk2.Attributes.String('Collection name')


class IMAGES_THUMBS_REQUESTS(sdk2.Resource):
    releasable = False
    auto_backup = True
    collection = sdk2.Attributes.String('Collection name')


class IMAGES_THUMBS_PLAN_2(sdk2.Resource):
    releasable = False
    auto_backup = True


class IMAGES_LINKDB_CLEANUPER(sdk2.Resource):
    """
        Executable to cleanup linkdb
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/cleanup/linkdb/linkdb_cleanup'


class PORTO_LAYER_IMGRQ_MMETA(sdk2.Resource):
    """
        Ext porto layer for imgrq2basemmeta
    """
    releasable = True
    releasers = images_releasers


class IMAGES_JUGGLER_CHECKS_BUNDLE(sdk2.Resource):
    """
        Juggler check bundle for images services
    """
    releasable = True
    releasers = images_releasers


class IMAGES_TAGS_DICT_UTIL_EXECUTABLE(sdk2.Resource):
    """
       Executable to apply models from dict group: lang recognizer, part-of-speech tagger, POS filter
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers + ['rakhunzy']
    arcadia_build_path = 'extsearch/images/robot/mrdb/tags/tools/tagsdictutil/tagsdictutil'


class IMAGES_RTCVDUP_VIEWER_EXECUTABLE(sdk2.Resource):
    """
       Rtcvdup viewer executable
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/rtcvdup/viewer/viewer'


class IMAGES_RTCVDUP_VIEWER_TEMPLATES(sdk2.Resource):
    """
        Jinja2 templates for rtcvdup viewer
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/rtcvdup/viewer/templates'


class IMAGES_RTCVDUP_VIEWER_STATIC(sdk2.Resource):
    """
       Static resources for rtcvdup viewer
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/rtcvdup/viewer/static'


class IMAGES_RTCVDUP_VIEWER_CONFIG(sdk2.Resource):
    """
       Configuration file for rtcvdup viewer
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/rtcvdup/viewer/config/rtcvdup_viewer.conf'


class IMAGES_RTROBOT_DBWALKER_EXECUTABLE(sdk2.Resource):
    """
       Rtrobot dbwalker executable
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/rtrobot/tools/db_walker/rtrobot_db_walker'


class IMAGES_RTROBOT_DBWALKER_CONFIG(sdk2.Resource):
    """
       Configuration file for Rtrobot dbwalker
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/rtrobot/tools/db_walker/config/db_walker.conf'


class IMAGES_BIN_WRANGLER(sdk2.Resource):
    """
       Wrangler for convertion of inverted index to the wad format see extsearch/images/robot/index/index_download for more info
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "search/panther/tools/wrangler/wrangler"


class IMAGES_BIN_YT_STATE_TOOL(sdk2.Resource):
    """
       Tool for managing states on yt
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/tools/yt_infra/yt_state_tool/yt_state_tool"


class IMAGES_BIN_YT_QUEUE_TOOL(sdk2.Resource):
    """
       Tool for managing queues on yt
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/tools/yt_infra/yt_queue_tool/yt_queue_tool"


class IMAGES_BIN_YT_OPERATION_TOOL(sdk2.Resource):
    """
       Tool for managing operations on yt
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/tools/yt_infra/yt_operation_tool/yt_operation_tool"


class IMAGES_YTCLOUD_PREPARE_EXECUTABLE(sdk2.Resource):
    """
       Exceutable to prepare exports for pocessing at ytcloud
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/robot/mrdb/ytcloud/prepare/ytcloud-prepare"


class IMAGES_YTCLOUD_YQLRUNNER_EXECUTABLE(sdk2.Resource):
    """
       Exceutable to run YQL queries at ytcloud
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/robot/mrdb/ytcloud/yqlrunner/yqlrunner"


class IMAGES_RTHUB_TOOL_EXECUTABLE(sdk2.Resource):
    """
       Exceutable to manage conversion of rthub exports to kiwirec format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/robot/mrdb/tools/images-rthub/images-rthub"


class IMAGES_THUMBS_CHECKSUMS(sdk2.Resource):
    """
        File with thumbs' urls and checksums
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers + images_rim_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_CM_PACKAGE(sdk2.Resource):
    """
        Resource for images cm
    """
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_CRCDB_DYNTAB_EXECUTABLE(sdk2.Resource):
    """
       Exceutable for crcdb dyntab
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/robot/mrdb/crcdb_dyntab/crcdb_dyntab"


class IMAGES_MR_INDEX_STATISTICS_HNSW(sdk2.Resource):
    """
    Executable for HNSM statistics https://st.yandex-team.ru/IMAGES-15808
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = "extsearch/images/robot/index/statistics/hnsw_index/hnsw_index"


class IMAGES_NN_OVER_DSSM_DOC_MODEL(sdk2.Resource):
    """
    Neural network tensor flow model over dssm(i2t + doc features)
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_NN_OVER_DSSM_QUERY_MODEL(sdk2.Resource):
    """
    Neural network over dssm over tensor flow model(i2t + images_production:TG_QUERY_TAG)
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_INVERTED_INDEX_EXECUTABLE(sdk2.Resource):
    """
        Inverted index executable (production)
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'search/base_search/daemons/inverted_index_storage/inverted_index_storage'


class IMAGES_INVERTED_INDEX_DATABASE(sdk2.Resource):
    """
       Partitioned panther (P-daemon) index database
    """

    releasable = False


class IMAGES_EMBEDDING_STORAGE_EXECUTABLE(sdk2.Resource):
    """
        Embedding storage executable (production)
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'search/base_search/daemons/embedding_storage/embedding_storage'


class IMAGES_L1_INTSEARCH_EXECUTABLE(sdk2.Resource):
    """
        L1 Intsearch executable
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'search/daemons/l1_intsearch/l1_intsearch'
    arcadia_build_name = 'intsearch'


class IMAGES_EMBEDDING_DATABASE(sdk2.Resource):
    """
       Search embedding (E-daemon) index database
    """

    releasable = False


class IMAGES_EVENTLOG_PLANNER_EXECUTABLE(sdk2.Resource):
    """
        Event log planner executable
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'extsearch/images/tools/evlog_planner/evlog_planner'


class IMAGES_SDR_COMPARE_EXECUTABLE(sdk2.Resource):
    """
        Event log planner executable
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'extsearch/images/tools/sdr_compare/sdr_compare'


class IMAGES_SEARCH_DAEMON_RESPONSES(sdk2.Resource):
    """
        Responses of various images search daemon
    """
    releasable = False


class IMAGES_SEARCH_DAEMON_COMPARE_RESULT(sdk2.Resource):
    """
        Responses of various images search daemon
    """
    releasable = False


class IMAGES_GEOA_C2P(sdk2.Resource):
    """
    geo2.c2p mrindexer config file
    """
    releasable = True
    release_subscribers = images_mrindex_subscribers


class IMAGES_DYNAMIC_L1_TOP_SIZE_ANALYZER_EXECUTABLE(sdk2.Resource):
    """
        Event log planner executable
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()
    arcadia_build_path = 'extsearch/images/tools/new_runtime/dynamic_l1_top_size_analyzer/dynamic_l1_top_size_analyzer'


class IMAGES_T2T_QUERY_MODEL(sdk2.Resource):
    """
        DSSM model t2t, query part
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


class IMAGES_BERT_DISTILL_QUERY_MODEL(sdk2.Resource):
    """
        DSSM model is bert distillation from web, query part
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
