from sandbox.sandboxsdk import sandboxapi

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common import utils
from sandbox.projects.common.mediasearch import yasm_task
from sandbox.projects.images.daemons import ImagesGenerateNaildaemonRequests as generate_naildaemon_task
from sandbox.projects.images.daemons import ImagesGenerateCbirdaemon2Requests as generate_cbirdaemon_task
from sandbox.projects.images.daemons import ImagesGenerateRimdaemonRequests as generate_rimdaemon_task
from sandbox.projects.images.resources import ImagesGenerateMiddlesearchRequests as generate_middlesearch_task
from sandbox.projects.images.resources import task as resources_task
from sandbox.projects.images.resources import fuzzing as resources_fuzzing

from sandbox import sdk2


_IMAGES_QUERIES_TYPES = {
    (media_settings.INDEX_MAIN, media_settings.ImagesSettings.SERP_TYPE_MAIN): {
        "cgi": "&snip=info_query_type=serp",
        "source": "IMAGES_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_SERP,
        "report_url": media_settings.ImagesSettings.HAMSTER_URL + "images/search?",
    },
    (media_settings.INDEX_MAIN, media_settings.ImagesSettings.SERP_TYPE_MAIN_QLANG): {
        "cgi": "&snip=info_query_type=serp",
        "source": "IMAGES_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_QLANG,
        "report_url": media_settings.ImagesSettings.HAMSTER_URL + "images/search?",
    },
    (media_settings.INDEX_MAIN, media_settings.ImagesSettings.SERP_TYPE_MAIN_XML): {
        "cgi": "&snip=info_query_type=xml_serp&type=pictures",
        "source": "IMAGES_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_SERP,
        "report_url": media_settings.ImagesSettings.XML_HAMSTER_URL + "search/xml?",
    },
    (media_settings.INDEX_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGEDUPS): {
        "cgi": "&snip=info_query_type=imagedups&rpt=imagedups",
        "source": "IMAGES_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR,
        "report_url": media_settings.ImagesSettings.HAMSTER_URL + "images/search?",
    },
    (media_settings.INDEX_CBIR_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGEVIEW): {
        "cgi": "&snip=info_query_type=imageview&rpt=imageview",
        "source": "IMAGESCBIR_MMETA,IMAGESCBIR_SIMILAR_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR,
        "report_url": media_settings.ImagesSettings.HAMSTER_URL + "images/search?",
    },
    (media_settings.INDEX_CBIR_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGELIKE): {
        "cgi": "&snip=info_query_type=imagelike&rpt=imagelike",
        "source": "IMAGESCBIR_MMETA,IMAGESCBIR_SIMILAR_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR,
        "report_url": media_settings.ImagesSettings.HAMSTER_URL + "images/search?",
        "index_type": media_settings.INDEX_CBIR_MAIN,
    },
    (media_settings.INDEX_CBIR_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGEDUPS_XML): {
        "cgi": "&snip=info_query_type=xml_imagedups&type=cbir",
        "source": "IMAGESCBIR_MMETA,IMAGESCBIR_SIMILAR_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR,
        "report_url": media_settings.ImagesSettings.XML_HAMSTER_URL + "search/xml?",
    },
    (media_settings.INDEX_CBIR_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGELIKE_XML): {
        "cgi": "&snip=info_query_type=xml_imagelike&type=cbirlike",
        "source": "IMAGESCBIR_MMETA,IMAGESCBIR_SIMILAR_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR,
        "report_url": media_settings.ImagesSettings.XML_HAMSTER_URL + "search/xml?",
    },
    (media_settings.INDEX_CBIR_MAIN, media_settings.ImagesSettings.SERP_TYPE_IMAGESIGN_XML): {
        "cgi": "&snip=info_query_type=xml_imagesign&type=cbirlike",
        "source": "IMAGESCBIR_MMETA,IMAGESCBIR_SIMILAR_MMETA",
        media_settings.ImagesSettings.QUERIES_ATTR_NAME: media_settings.ImagesSettings.QUERIES_TYPE_CBIR_SIGN,
        "report_url": media_settings.ImagesSettings.XML_HAMSTER_URL + "search/xml?",
    },
}


_MIDDLE_REQUEST_TASK_IDS = "middle_request_tasks"
_BASE_PLAN_TASK_IDS = "base_plan_tasks"
_NAILDAEMON_PLAN_TASK_IDS = "naildaemon_plan_task_ids"
_CBIRDAEMON_PLAN_TASK_IDS = "cbirdaemon_plan_task_ids"
_RIMDAEMON_PLAN_TASK_IDS = "rimdaemon_plan_task_ids"
_RIMPATCHDAEMON_PLAN_TASK_IDS = "rimpatchdaemon_plan_task_ids"


class ImagesGenerateTestenvData(yasm_task.YasmTask,
                                resources_task.ImagesProductionResourcesTask,
                                resources_task.GenerateResourcesTask):
    """
        Generate test plans from fixed user requests
    """

    type = 'IMAGES_GENERATE_TESTENV_DATA'
    push_signal_name = "generate_testenv_data"

    def on_execute(self):
        if _MIDDLE_REQUEST_TASK_IDS not in self.ctx:
            result = {}
            for key, settings in _IMAGES_QUERIES_TYPES.iteritems():
                index_type, serp_type = key
                result[",".join(key)] = self._create_middlesearch_queries(index_type, serp_type, settings)
            self.ctx[_MIDDLE_REQUEST_TASK_IDS] = result

        if _BASE_PLAN_TASK_IDS not in self.ctx:
            result = {}
            for key, settings in _IMAGES_QUERIES_TYPES.iteritems():
                index_type, serp_type = key
                result[",".join(key)] = self._generate_resources(
                    media_settings.INDEX_MIDDLE,
                    index_type,
                    serp_type,
                    enable_apphost=not settings.get("xml_report", False)
                )
            self.ctx[_BASE_PLAN_TASK_IDS] = result

        if _NAILDAEMON_PLAN_TASK_IDS not in self.ctx:
            self.ctx[_NAILDAEMON_PLAN_TASK_IDS] = self.__generate_naildaemon_resources()

        if _CBIRDAEMON_PLAN_TASK_IDS not in self.ctx:
            self.ctx[_CBIRDAEMON_PLAN_TASK_IDS] = self.__generate_cbirdaemon_resources()

        if _RIMDAEMON_PLAN_TASK_IDS not in self.ctx:
            self.ctx[_RIMDAEMON_PLAN_TASK_IDS] = self.__generate_rimdaemon_resources()

        if _RIMPATCHDAEMON_PLAN_TASK_IDS not in self.ctx:
            self.ctx[_RIMPATCHDAEMON_PLAN_TASK_IDS] = self.__generate_rimpatchdaemon_resources()

        utils.check_subtasks_fails(fail_on_first_failure=True)
        self._yasm_notify()

    def _create_middlesearch_queries(self, index_type, serp_type, settings):
        query_type = settings[media_settings.ImagesSettings.QUERIES_ATTR_NAME]

        testenv_attr_key, testenv_attr_value = media_settings.ImagesSettings.testenv_middlesearch_queries_attributes(
            media_settings.INDEX_MIDDLE,
            index_type,
            serp_type=serp_type
        )
        middlesearch_attributes = {testenv_attr_key: testenv_attr_value}
        middlesearch_attributes.update(self._get_middlesearch_shard_attributes(index_type))
        middlesearch_attributes = ",".join("{}={}".format(k, v) for k, v in middlesearch_attributes.iteritems())

        sub_ctx = {
            generate_middlesearch_task.ReportUrl.name: settings["report_url"],
            generate_middlesearch_task.TextQueries.name: self.__get_user_queries(query_type),
            generate_middlesearch_task.AdditionalCgiParams.name: settings["cgi"],
            generate_middlesearch_task.AdditionalAttributes.name: middlesearch_attributes,
            generate_middlesearch_task.SourceName.name: settings["source"],
            generate_middlesearch_task.XmlReport.name: settings.get("xml_report", False),
        }

        sub_task = self.create_subtask(
            task_type=generate_middlesearch_task.ImagesGenerateMiddlesearchRequests.type,
            input_parameters=sub_ctx,
            description='{}, {}, {}'.format(self.descr, index_type, serp_type),
            inherit_notifications=True
        )
        return sub_task.id

    def _get_basesearch_attributes(self, index_type, serp_type):
        return media_settings.ImagesSettings.testenv_basesearch_queries_attributes(index_type, serp_type=serp_type)

    def _get_middlesearch_plan(self, meta_index_type, base_index_type, serp_type):
        task_id = self.ctx[_MIDDLE_REQUEST_TASK_IDS][",".join((base_index_type, serp_type))]
        return apihelpers.list_task_resources(task_id, resource_types.IMAGES_MIDDLESEARCH_PLAN)[0].id

    def __get_user_queries(self, query_type):
        return apihelpers.get_last_resource_with_attribute(
            resource_types.USERS_QUERIES,
            media_settings.ImagesSettings.QUERIES_ATTR_NAME,
            query_type
        ).id

    def __generate_naildaemon_resources(self):
        index_type = media_settings.INDEX_THUMB_QUICK
        query_type = "synthetic"
        attribute_name, attribute_value = media_settings.ImagesSettings.testenv_basesearch_queries_attributes(
            index_type,
            query_type,
        )
        sub_ctx = {
            generate_naildaemon_task.AttributesParameter.name: "{}={}".format(attribute_name, attribute_value),
            generate_naildaemon_task.DatabaseParameter.name: self._get_basesearch_database(index_type),
            resources_fuzzing.UpdateFuzzingResourcesParameter.name: True,
        }
        sub_task = self.create_subtask(
            task_type=generate_naildaemon_task.ImagesGenerateNaildaemonRequests.type,
            description="{}, {} {}".format(self.descr, index_type, query_type),
            input_parameters=sub_ctx,
            arch=sandboxapi.ARCH_LINUX,
            inherit_notifications=True
        )
        return sub_task.id

    def __generate_cbirdaemon_resources(self):
        index_type = media_settings.INDEX_CBIR_DAEMON
        attribute_name, attribute_value = media_settings.ImagesSettings.testenv_basesearch_queries_attributes(
            index_type,
        )
        naildaemon_index_type = media_settings.INDEX_THUMB_QUICK
        naildaemon_params = generate_cbirdaemon_task.NAILDAEMON_PARAMS
        sub_ctx = {
            naildaemon_params.Binary.name: self._get_basesearch_executable(naildaemon_index_type),
            naildaemon_params.Config.name: self._get_basesearch_config(naildaemon_index_type),
            naildaemon_params.Database.name: self._get_basesearch_database(naildaemon_index_type),
            generate_cbirdaemon_task.AttributesParameter.name: "{}={}".format(attribute_name, attribute_value),
            resources_fuzzing.UpdateFuzzingResourcesParameter.name: True,
        }
        sub_task = self.create_subtask(
            task_type=generate_cbirdaemon_task.ImagesGenerateCbirdaemon2Requests.type,
            description="{}, {}".format(self.descr, index_type),
            input_parameters=sub_ctx,
            arch=sandboxapi.ARCH_LINUX,
            inherit_notifications=True
        )
        return sub_task.id

    def __generate_rimdaemon_resources(self):
        index_type = media_settings.INDEX_RIM
        query_type = "synthetic"
        attribute_name, attribute_value = media_settings.ImagesSettings.testenv_basesearch_queries_attributes(
            index_type,
            query_type,
        )
        sub_ctx = {
            generate_rimdaemon_task.AttributesParameter.name: "{}={}".format(attribute_name, attribute_value),
            generate_rimdaemon_task.DatabaseParameter.name: self._get_basesearch_database(index_type),
            resources_fuzzing.UpdateFuzzingResourcesParameter.name: True,
        }
        sub_task = self.create_subtask(
            task_type=generate_rimdaemon_task.ImagesGenerateRimdaemonRequests.type,
            description="{}, {} {}".format(self.descr, index_type, query_type),
            input_parameters=sub_ctx,
            arch=sandboxapi.ARCH_LINUX,
            inherit_notifications=True
        )
        return sub_task.id

    def __get_rim_responses_resource(self):
        index_type = media_settings.INDEX_RIM
        query_type = "synthetic"
        attribute_name, attribute_value = media_settings.ImagesSettings.testenv_basesearch_queries_attributes(
            index_type,
            query_type,
        )
        return utils.get_and_check_last_resource_with_attribute(
            resource_types.THUMB_DAEMON_RESPONSES_ARCHIVE,
            attribute_name,
            attribute_value
        ).id

    def __generate_rimpatchdaemon_resources(self):
        index_type = media_settings.INDEX_RIMPATCH
        query_type = "synthetic"
        attribute_name, attribute_value = media_settings.ImagesSettings.testenv_basesearch_queries_attributes(
            index_type,
            query_type,
        )
        requests_sub_task = sdk2.Task["IMAGES_GENERATE_RIMPATCHDAEMON_REQUESTS"]
        requests_sub_task_id = requests_sub_task(requests_sub_task.current,
            description="{}, {} {}".format(self.descr, index_type, query_type),
            owner=self.owner,
            priority=self.priority,
            attributes="{}={}".format(attribute_name, attribute_value),
            rim_response=self.__get_rim_responses_resource(),
            arch=sandboxapi.ARCH_LINUX,
            inherit_notifications=True
        ).enqueue().id
        ban_archive_sub_task = sdk2.Task["IMAGES_GENERATE_RIMPATCHDAEMON_BAN_ARCHIVE"]
        ban_archive_sub_task_id = ban_archive_sub_task(ban_archive_sub_task.current,
            description="{}, {} {}".format(self.descr, index_type, query_type),
            owner=self.owner,
            priority=self.priority,
            attributes="{}={}".format(attribute_name, attribute_value),
            arch=sandboxapi.ARCH_LINUX,
            inherit_notifications=True
        ).enqueue().id
        return (requests_sub_task_id, ban_archive_sub_task_id)


__Task__ = ImagesGenerateTestenvData
