import os.path
import urllib2
import urlparse
import shutil

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import decorators
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.mediasearch import yasm_task
from sandbox.projects.images.resources import task as resources_task


_RESOURCES = {
    resource_types.FML_REQUESTS_TABLE: "http://fml.yandex-team.ru/api/get/images.ru/requests.ImgTier0.tsv.gz",
    resource_types.FML_RATINGS_TABLE: "http://fml.yandex-team.ru/api/get/images.ru/ratings.tsv.gz",
}
_OUT_KEY = "output_resources"
_EXECUTED_KEY = "_task_executed"

_TIMEOUT = 60


class ImagesLoadFmlTestenvData(yasm_task.YasmTask,
                               resources_task.ImagesProductionResourcesTask,
                               task.SandboxTask):
    """
        Load actual data from FML for tests
    """

    type = 'IMAGES_LOAD_FML_TESTENV_DATA'

    input_parameters = []
    push_signal_name = "load_fml_testenv_data"

    def on_enqueue(self):
        task.SandboxTask.on_enqueue(self)

        self.ctx[_OUT_KEY] = [
            self.create_resource(
                self.descr,
                self.__local_resource_path(url),
                resource,
                arch=sandboxapi.ARCH_ANY,
                attributes=dict([media_settings.ImagesSettings.testenv_resource_attributes('fml')])
            ).id
            for resource, url in _RESOURCES.iteritems()
        ]

    def on_execute(self):
        # yasm_notify can raise TemporaryError, so we need to avoid a double work
        if _EXECUTED_KEY not in self.ctx:
            self.__on_execute()
            self.ctx[_EXECUTED_KEY] = 1

        self._yasm_notify()

    def __on_execute(self):
        for url in _RESOURCES.itervalues():
            self.__download_resource(url)

        attribute_name = media_settings.SHARD_INSTANCE_ATTRIBUTE_NAME
        attribute_value = self._get_basesearch_shard_name(media_settings.INDEX_MAIN)
        for resource_id in self.ctx[_OUT_KEY]:
            channel.sandbox.set_resource_attribute(resource_id, attribute_name, attribute_value)

    @classmethod
    @decorators.retries(max_tries=5, delay=1)
    def __download_resource(cls, url):
        with open(cls.__local_resource_path(url), "w") as local_file:
            shutil.copyfileobj(urllib2.urlopen(url, None, _TIMEOUT), local_file)

    @staticmethod
    def __local_resource_path(url):
        return os.path.basename(urlparse.urlparse(url).path)


__Task__ = ImagesLoadFmlTestenvData
