from sandbox.projects import resource_types
from sandbox.projects.images.rim import resources as rim_resources

from sandbox.projects.common.BaseImagesBuildBundle import BaseImagesBuildBundle
from sandbox.projects.common import BaseImagesBundleReplaces


class ImagesBuildMainRimDeployBundle(BaseImagesBuildBundle):
    """
        Build deploy rim bundle
    """

    type = 'IMAGES_BUILD_MAIN_RIM_DEPLOY_BUNDLE'

    __STABLE_SERVICES = ['mr_rim']

    resource_replaces = (
        [resource_types.IMAGES_MR_INDEX_SHARDWRITER, BaseImagesBundleReplaces.ShardWriterReplace],
        [resource_types.SHARDTOOL, BaseImagesBundleReplaces.ShardToolReplace],
        [resource_types.IMAGES_MAIN_RIM_DOWNLOAD, BaseImagesBundleReplaces.ShardDownloadReplace],
        [resource_types.SHARDTOOL_CONFIG_IMGSRIM, BaseImagesBundleReplaces.ShardToolConfigReplace],
    )

    input_parameters = BaseImagesBuildBundle.input_parameters + \
                       [param for _, param in resource_replaces]

    def get_built_resources(self):
        return (
            [resource_types.IMAGES_MR_INDEX_SHARDWRITER, 'shardwriter'],
            [resource_types.SHARDTOOL, 'shard_tool'],
            [resource_types.IMAGES_MAIN_RIM_DOWNLOAD, 'shard_download'],
            [resource_types.SHARDTOOL_CONFIG_IMGSRIM, 'config.json'],
        )

    def get_resources(self):
        return ()

    def get_resource_type(self):
        return rim_resources.IMAGES_RIM_DEPLOY_BUNDLE

    def get_resource_replaces(self):
        return self.resource_replaces

    def get_resource_descr(self):
        return 'Rim deploy bundle'

    def get_resource_file_name(self):
        return 'imgsrim'

    def get_stable_services(self):
        return self.__STABLE_SERVICES


__Task__ = ImagesBuildMainRimDeployBundle
