from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.images.rim import resources as rim_resources


class ImagesBuildSemidupsProcessingBinaries(BaseMediaBuildTask):
    """
       Binaries for semidups processing binaries building
    """

    type = 'IMAGES_BUILD_SEMIDUPS_PROCESSING_BINARIES'
    execution_space = 100*1024  # 100 GB

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True
        self.ctx[consts.THINLTO] = True
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.SEMI_DISTBUILD_BUILD_SYSTEM

    def get_binaries(self):
        return (
            rim_resources.IMAGES_SEMIDUPS_PROCESSING_EXECUTABLE
        )

    def get_configs(self):
        return (
        )


__Task__ = ImagesBuildSemidupsProcessingBinaries
