from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class RimResource(sdk2.Resource):
    auto_backup = True
    releasers = get_current_images_devops('robot-images-sandbox')
    release_subscribers = ['images-releases']


class IMAGES_RIM_DEPLOY_BUNDLE(RimResource):
    """
       RIM deploy bundle
    """
    releasable = True
    executable = True


class IMAGES_RIMDB_RIMTHUMBS_EXECUTABLE(RimResource):
    """
       'rim-thumbs' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/thumbs/rim_thumbs'


class IMAGES_SEMIDUPS_PROCESSING_EXECUTABLE(RimResource):
    """
       'semidups_processing' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/duck/tools/semidups_processing/semidups_processing'


class IMAGES_RIMDB_SCHEMAORG_EXECUTABLE(RimResource):
    """
       'rim_schema_org' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/schema_org/tools/rim_schema_org'


class IMAGES_RIMDB_RIM_SHARDS_SIZE_EXECUTABLE(RimResource):
    """
       'rim_shards_size' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/utils/rim_shards_size/rim_shards_size'


class IMAGES_RIMDB_YT_DAEMON_EXECUTABLE(RimResource):
    """
       'rim_db_daemon' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/daemon/rim_db_daemon'


class IMAGES_RIM_TOOLS_TAAS_RUN_TIME_EXECUTABLE(RimResource):
    """
        'rim_taas_time' binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/utils/rim_taas_time/rim_taas_time'


class IMAGES_RIM_RIMDB_BUILDER_PARSE_METADOC_EXECUTABLE(RimResource):
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/rimdb_builder/tools/parse_metadoc/parse_metadoc'


class IMAGES_RIM_CM_PACKAGE(RimResource):
    """
        'images rim cm' package
    """
    releasable = True
    auto_backup = True
