from sandbox import sdk2
from sandbox.projects.images.ImagesCmApi.task import ImagesCmApiTask

_CHECK_INTERVAL = 30 * 60  # 30 minutes


class ImagesRobotCmRunWait(ImagesCmApiTask):
    """
        Images robot run and wait goal cm
    """

    class Parameters(ImagesCmApiTask.Parameters):
        cm_goal = sdk2.parameters.String("CM goal wait name", default_value="workflow-finish")
        wait_goal = sdk2.parameters.Bool("Should task wait success goal", default=True)
        use_last_binary = sdk2.parameters.Bool("Use last binary archive", default=False)

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(attrs={'name': 'ImagesRobotCmRunWait'}).first()

    def on_execute(self):
        cmapi = super(ImagesRobotCmRunWait, self).get_cm_api()
        with self.memoize_stage.start_goal(commit_on_entrance=False):
            cmapi.launch_target(self.Parameters.cm_goal)

        if not self.Parameters.wait_goal:
            return

        current_target = cmapi.get_state(self.Parameters.cm_goal)
        if current_target not in ("success",):
            raise sdk2.WaitTime(_CHECK_INTERVAL)
