from sandbox import sdk2

images_robot_releasers = [
    'igorluk',
    'ulgen4a',
    'anskor',
    'sakhnov',
    'robot-images-sandbox',
    'robot-testenv',
    'ivankol',
    'fexion',
    'kozlovkr',
    'gritsaev',
    'foxxmary',
    'mrboogie',
    'evseevd',
    'wwfq',
]

images_robot_subscribers = images_robot_releasers + []


class ImagesRobotResource(sdk2.Resource):
    auto_backup = True
    releasers = images_robot_releasers
    release_subscribers = images_robot_subscribers


class ImagesRobotResourcesList(ImagesRobotResource):
    """
       Files with resource id list
    """
    releasable = True


class IMAGES_MAIN_ROBOT_PACKAGE(sdk2.Resource):
    """
        Resource for images main robot package
    """
    releasable = True
    auto_backup = True
    releasers = images_robot_releasers
    release_subscribers = images_robot_subscribers
