# -*- encoding: utf-8 -*-
from sandbox.projects import resource_types
from sandbox.projects.images.rq import resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class ImagesRqBuildRobotBin(BaseMediaBuildTask):
    '''
        Собрать роботные бинарники.
    '''
    type = 'IMAGES_RQ_BUILD_ROBOT_BIN'

    def get_binaries(self):
        return (
            resources.IMAGES_RQ_CONFIGURE_GLUEING_EXECUTABLE,
            resources.IMAGES_RQ_GLUE_THUMBS_EXECUTABLE,
            resources.IMAGES_RQ_HEAD_TABLE_PREPROCESSOR_EXECUTABLE,
            resources.IMAGES_RQ_HEAD_GENERATOR_EXECUTABLE,
            resources.IMAGES_RQ_INPUTDOC_CREATOR_EXECUTABLE,
            resources.IMAGES_RQ_INDEXER_EXECUTABLE,
            resources.IMAGES_RQ_USER_SESSIONS_SERP_INFOS_EXTRACTOR_EXECUTABLE,
            resources.IMAGES_RQ_THUMBS_UPDATER,
            resources.IMAGES_RQ_THUMBS_FILTERER_EXECUTABLE,
            resources.IMAGES_RQ_MIDDLESEARCH_BAN_BUILDER,
            resources.IMAGES_RQ_ROBOT_EXECUTABLE,
            resources.IMAGES_RQ_STATS_EXECUTABLE,
            resources.IMAGES_RQ_THUMBS_PORNO_SHARER_EXECUTABLE
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_METRICS_API_SCRIPT,
            resource_types.IMAGES_STATE_ACCEPTOR_SCRIPT
        )


__Task__ = ImagesRqBuildRobotBin
