# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class RqResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops('anoh', 'pupatenko', 'panovav', 'robot-imgrq', 'robot-images-sandbox')


class IMAGES_RQ2_CLICK_SHARDMAP(RqResource):
    """
        Images related queries click shardmap
    """
    any_arch = False
    executable = False
    RqResource.releasers += []
    shardmap = True


class IMAGES_RQ_BASESEARCH_EXECUTABLE(RqResource):
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/base/rqsearch/rqsearch'


class IMAGES_RQ_BASESEARCH_CONFIG(RqResource):
    arcadia_path = 'extsearch/images/related_queries/base/rqsearch/config/config.cfg'


class IMAGES_RQ_SEARCH_SHARD_MAP(RqResource):
    """
        Images Related Queries shardmap
    """
    any_arch = False
    executable = False
    shardmap = True


class IMAGES_RQ_HEAD_TABLE_PREPROCESSOR_EXECUTABLE(RqResource):
    """
        Исполняемый файл head_table_preprocessor связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/head_table_preprocessor/head_table_preprocessor'


class IMAGES_RQ_THUMBS_UPDATER(RqResource):
    """
        Исполняемый файл update_thumbs связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/update_thumbs/update_thumbs'


class IMAGES_RQ_HEAD_GENERATOR_EXECUTABLE(RqResource):
    """
        Исполняемый файл head_generator связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/head_generator/head_generator'


class IMAGES_RQ_INPUTDOC_CREATOR_EXECUTABLE(RqResource):
    """
        Исполняемый файл inputdoc_creator связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/inputdoc_creator/inputdoc_creator'


class IMAGES_RQ_INDEXER_EXECUTABLE(RqResource):
    """
        Исполняемый файл indexer связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/functionality/index/indexer/indexer'


class IMAGES_RQ_USER_SESSIONS_SERP_INFOS_EXTRACTOR_EXECUTABLE(RqResource):
    """
        Исполняемый файл user_sessions_thumbs связанных запросов Яндекс.Картинок
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/user_sessions_serp_infos/user_sessions_serp_infos'


class IMAGES_RQ_THUMBS_FILTERER_EXECUTABLE(RqResource):
    """
        Исполняемый файл filter_thumbs связанных запросов Яндекс.Картинок.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/functionality/tools/filter_thumbs/filter_thumbs'


class IMAGES_RQ_THUMBS_PORNO_SHARER_EXECUTABLE(RqResource):
    """
        Исполняемый файл porno-sharer связанных запросов Яндекс.Картинок.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/porno_sharer/porno-sharer'


class IMAGES_RQ_ROBOT_EXECUTABLE(RqResource):
    """
        Исполняемый файл питоновского робота связанных запросов Яндекс.Картинок.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/robot/bin/rq_robot'


class IMAGES_RQ_GLUE_THUMBS_EXECUTABLE(RqResource):
    """
        Утилита склейки тумбов связанных запросов
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/glue_thumbs/glue_thumbs'


class IMAGES_RQ_STATS_EXECUTABLE(RqResource):
    """
        Исполняемый файл модуля сбора статистики связанных запросов Яндекс.Картинок.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/robot/stats/rq_stats'


class IMAGES_RQ_CONFIGURE_GLUEING_EXECUTABLE(RqResource):
    """
        Утилита конфигурирования склейки тумбов связанных запросов
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/configure_glueing/configure_glueing'


class IMAGES_RQ_SHARD_BUILDER(RqResource):
    """
        Скрипт для создания шарда связанных запросов Яндекс.Картинок
    """
    arcadia_path = 'extsearch/images/related_queries/robot/scripts/img-rq-shard-builder.sh'


class IMAGES_RQ_MIDDLESEARCH_BAN_BUILDER(RqResource):
    """
        Исполняемый файл, который строит бан на среднем для связанных запросов Яндекс.Картинок.
    """
    release_subscribers = ['anoh']
    executable = True
    arcadia_build_path = 'extsearch/images/related_queries/tools/ban_builder/ban_builder'


class IMAGES_RQ_MIDDLESEARCH_QUERY_BAN_VERSION(RqResource):
    """
        Файл с версией запросного бана связанных запросов Яндекс.Картинок
    """
    release_subscribers = ['anoh']


class IMAGES_RQ_MIDDLESEARCH_QUERY_BAN_FILE(RqResource):
    """
        Файл с запросным баном связанных запросов Яндекс.Картинок
    """
    release_subscribers = ['anoh']
    any_arch = True
    basename = 'rq-query-ban.trie'


class IMAGES_RQ_MIDDLESEARCH_QUERY_PAIR_BAN_VERSION(RqResource):
    """
        Файл с версией запросно-запросного бана связанных запросов Яндекс.Картинок
    """
    release_subscribers = ['anoh']


class IMAGES_RQ_MIDDLESEARCH_QUERY_PAIR_BAN_FILE(RqResource):
    """
        Файл с запросно-запросного баном связанных запросов Яндекс.Картинок
    """
    release_subscribers = ['anoh']
    any_arch = True
    basename = 'rq-query-pair-ban.trie'


class IMAGES_RQ_BINARY_DEPENDENCIES(RqResource):
    """
        Данные зависимостей для бинарей робота.
    """


class IMAGES_RQ_INTEGRATION_TESTS_TABLES(sdk2.Resource):
    """
        Блобы таблиц для интерграционных тестов в файловой структуре, аналогичной кипарису на кластере
    """


class IMAGES_RQ_VW_CP_MODEL(RqResource):
    """
        vowpal-wabbit-packed-ann-cp-model.bin resource for images rq
    """
    any_arch = True
    executable = False
    release_subscribers = ['pupatenko', 'robot-imgrq']


class IMAGES_RQ_VW_GRUESOME_MODEL(RqResource):
    """
        vowpal-wabbit-packed-ann-gruesome-model.bin resource for images rq
    """
    any_arch = True
    executable = False
    release_subscribers = ['pupatenko', 'robot-imgrq']


class IMAGES_RQ_VW_PORN_MODEL(RqResource):
    """
        vowpal-wabbit-packed-ann-porn-model.bin resource for images rq
    """
    any_arch = True
    executable = False
    release_subscribers = ['pupatenko', 'robot-imgrq']
