# -*- coding: utf-8 -*-

from sandbox.projects.images.rtcvdup import resources as rtcvdup_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class ImagesBuildRtCvdupBinaries(BaseMediaBuildTask):
    """
        Binaries for rtcvdup service
    """

    type = 'IMAGES_BUILD_RTCVDUP_BINARIES'
    execution_space = 120000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = False

    def get_binaries(self):
        return (
            rtcvdup_resources.IMAGES_RTCVDUP_EXECUTABLE,
        )

    def get_configs(self):
        return (
            rtcvdup_resources.IMAGES_RTCVDUP_QUICK_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_QUICK_CONFIG_ACCEPT,
            rtcvdup_resources.IMAGES_RTCVDUP_MAIN_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_MAIN_CONFIG_ACCEPT,
            rtcvdup_resources.IMAGES_RTCVDUP_QUICK_SHARDMAP,
            rtcvdup_resources.IMAGES_RTCVDUP_MAIN_SHARDMAP,
            rtcvdup_resources.IMAGES_RTCVDUP_SHARDING_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_SHARDING_V9_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_INPUTPQ_LOOP_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_SEMIDUPS_LOOP_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_SEMIDUPS_YP_LOOP_CONFIG,
            rtcvdup_resources.IMAGES_RTCVDUP_STATISTICS_LOOP_CONFIG,
        )


__Task__ = ImagesBuildRtCvdupBinaries
