from sandbox import sdk2


images_rtcvdup_releasers = [
    'igorluk',
    'ulgen4a',
    'anskor',
    'sakhnov',
    'robot-images-sandbox'
]


images_rtcvdup_subscribers = images_rtcvdup_releasers + []


class ImagesRtCvdupResource(sdk2.Resource):
    auto_backup = True
    releasers = images_rtcvdup_releasers
    release_subscribers = images_rtcvdup_subscribers


class IMAGES_RTCVDUP_EXECUTABLE(ImagesRtCvdupResource):
    """
       RtCvdup executable
    """
    any_arch = False
    executable = True
    releasable = True
    arcadia_build_path = 'extsearch/images/robot/rtcvdup/app/rtcvdup'


"""
    TODO: move IMAGES_RTCVDUP_CONVERT_SNAPSHOT here
"""


class IMAGES_RTCVDUP_QUICK_CONFIG(ImagesRtCvdupResource):
    """
      RtCvdup configration quick installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_fast.conf'


class IMAGES_RTCVDUP_QUICK_CONFIG_ACCEPT(ImagesRtCvdupResource):
    """
      RtCvdup configration quick acceptance installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_quick_accept.conf'


class IMAGES_RTCVDUP_MAIN_CONFIG(ImagesRtCvdupResource):
    """
      RtCvdup configration main installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_main.conf'


class IMAGES_RTCVDUP_MAIN_CONFIG_ACCEPT(ImagesRtCvdupResource):
    """
      RtCvdup configration main acceptance installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_main_accept.conf'


class IMAGES_RTCVDUP_QUICK_SHARDMAP(ImagesRtCvdupResource):
    """
      RtCvdup shardmap for yp for quick installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_quick_shardmap.conf'


class IMAGES_RTCVDUP_MAIN_SHARDMAP(ImagesRtCvdupResource):
    """
      RtCvdup shardmap for yp for main installation
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/rtcvdupdaemon_main_shardmap.conf'


class IMAGES_RTCVDUP_SHARDING_CONFIG(ImagesRtCvdupResource):
    """
      RtCvdup sharding config
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/prod_v5_enc_toloka_96_20180308-195329_s16_i20'


class IMAGES_RTCVDUP_SHARDING_V9_CONFIG(ImagesRtCvdupResource):
    """
      RtCvdup sharding config for nn ver9
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/prod_v9_enc_toloka_96_20201112-000000_s16_i20'


class IMAGES_RTCVDUP_INPUTPQ_LOOP_CONFIG(ImagesRtCvdupResource):
    """
      Configuration file for instancectl - input pq component
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/input-pq.loop.conf'


class IMAGES_RTCVDUP_SEMIDUPS_LOOP_CONFIG(ImagesRtCvdupResource):
    """
      Configuration file for instancectl - semidups component
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/semidups.loop.conf'


class IMAGES_RTCVDUP_SEMIDUPS_YP_LOOP_CONFIG(ImagesRtCvdupResource):
    """
      Configuration file for instancectl in yp - semidups component
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/semidups.yp.loop.conf'


class IMAGES_RTCVDUP_STATISTICS_LOOP_CONFIG(ImagesRtCvdupResource):
    """
      Configuration file for instancectl - statistics component
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/rtcvdup/dist/statistics.loop.conf'
