# -*- coding: utf-8 -*-

from sandbox.projects.images.rthub import resources as rthub_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as constants
import sandbox.projects.common.build.parameters as build_params


class ImagesBuildRthubUdfs(BaseMediaBuildTask):
    """
       Udfs for rthub
    """

    type = 'IMAGES_BUILD_RTHUB_UDFS'
    execution_space = 120000

    def initCtx(self):
        self.ctx[constants.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            rthub_resources.IMAGES_RTHUB_IMAGES_UDF,
            rthub_resources.IMAGES_RTHUB_IMAGES_HTML_UDF,
            rthub_resources.IMAGES_RTHUB_IMAGES_NN_UDF,
            rthub_resources.IMAGES_RTHUB_IMAGES_OCR_UDF,
            rthub_resources.IMAGES_RTHUB_IMAGES_OCR_DATA,
            rthub_resources.IMAGES_RTHUB_IMAGES_PIC_UDF,
            rthub_resources.IMAGES_RTHUB_IMAGES_MDS_UDF
        )


__Task__ = ImagesBuildRthubUdfs
