from sandbox import sdk2

images_rthub_releasers = [
    'vitamin-ca',
    'ulgen4a',
    'igorluk',
    'ivankol',
    'robot-images-sandbox',
    'uzhas',
    "mrboogie",
]

images_rthub_subscribers = images_rthub_releasers + []


class ImagesRthubUdfResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = images_rthub_releasers
    release_subscribers = images_rthub_subscribers
    any_arch = False
    executable = True


class ImagesRthubDatafResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = images_rthub_releasers
    release_subscribers = images_rthub_subscribers
    any_arch = False
    executable = False


class RTHubImagesLbBalancerFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = images_rthub_releasers
    release_subscribers = images_rthub_subscribers


class IMAGES_RTHUB_IMAGES_UDF(ImagesRthubUdfResource):
    """
       libimages_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images/libimages_udf.so'


class IMAGES_RTHUB_IMAGES_HTML_UDF(ImagesRthubUdfResource):
    """
       libimages_html_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images_html/libimages_html_udf.so'


class IMAGES_RTHUB_IMAGES_NN_UDF(ImagesRthubUdfResource):
    """
       libimages_nn_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images_nn/libimages_nn_udf.so'


class IMAGES_RTHUB_IMAGES_OCR_UDF(ImagesRthubUdfResource):
    """
       libimages_ocr_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images_ocr/libimages_ocr_udf.so'


class IMAGES_RTHUB_IMAGES_OCR_DATA(ImagesRthubDatafResource):
    """
       ocrdata.tar
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images_ocr/ocrdata/ocrdata.tar'


class IMAGES_RTHUB_IMAGES_PIC_UDF(ImagesRthubUdfResource):
    """
       libimages_pic_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/images_pic/libimages_pic_udf.so'


class IMAGES_RTHUB_IMAGES_MDS_UDF(ImagesRthubUdfResource):
    """
       libmds_udf.so
    """
    arcadia_build_path = 'robot/rthub/yql/udfs/mds/libmds_udf.so'
