# -*- coding: utf-8 -*-

from sandbox.projects.common.nanny import auto_deploy
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
from sandbox.projects.images.rtrobot_panel import resources as rtrobot_panel_resources


class ImagesBuildRtrobotPanel(auto_deploy.AutoNannyDeployTask, BaseMediaBuildTask):
    """
        Rtrobot Panel
    """

    type = "IMAGES_BUILD_RTROBOT_PANEL"

    def get_stable_services(self):
        return ["rtrobot_panel"]

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_binaries(self):
        return (
            rtrobot_panel_resources.IMAGES_RTROBOT_PANEL_EXECUTABLE,
        )

    def get_configs(self):
        return (
            rtrobot_panel_resources.IMAGES_RTROBOT_PANEL_CONFIGS,
            rtrobot_panel_resources.IMAGES_RTROBOT_PANEL_STATIC,
            rtrobot_panel_resources.IMAGES_RTROBOT_PANEL_TEMPLATES,
        )


__Task__ = ImagesBuildRtrobotPanel
