from sandbox import sdk2


images_rtrobot_panel_releasers = [
    'fexion',
    'anskor',
]

images_rtrobot_panel_subscribers = images_rtrobot_panel_releasers + []


class ImagesRtrobotPanelResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = images_rtrobot_panel_releasers
    release_subscribers = images_rtrobot_panel_subscribers


class IMAGES_RTROBOT_PANEL_EXECUTABLE(ImagesRtrobotPanelResource):
    """
        RTRobot Panel executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/rtrobot/panel/rtrobot_panel'


class IMAGES_RTROBOT_PANEL_STATIC(ImagesRtrobotPanelResource):
    """
        RTRobot Panel static resources
    """
    arcadia_path = 'extsearch/images/robot/rtrobot/panel/static'


class IMAGES_RTROBOT_PANEL_TEMPLATES(ImagesRtrobotPanelResource):
    """
        RTRobot Panel Jinja2 templates
    """
    arcadia_path = 'extsearch/images/robot/rtrobot/panel/templates'


class IMAGES_RTROBOT_PANEL_CONFIGS(ImagesRtrobotPanelResource):
    """
        RTRobot Panel configs
    """
    arcadia_path = 'extsearch/images/robot/rtrobot/panel/config'
