import sandbox.projects.images.saas_acceptance.resources as saas_acceptance_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class ImagesBuildSaasAcceptanceBinariesAndConfigs(BaseMediaBuildTask):
    """
        Binaries and configs for saas acceptance
    """

    type = 'IMAGES_BUILD_SAAS_ACCEPTANCE_BINARIES_AND_CONFIGS'
    execution_space = 80000

    def initCtx(self):
        pass

    def get_binaries(self):
        return (
            saas_acceptance_resources.SaasBasesearchDownloadBackupShardScript,
        )

    def get_configs(self):
        return (
            saas_acceptance_resources.SaasIndexerproxyCheckStatusScript,
            saas_acceptance_resources.SaasIndexerproxyBackupSearchmap,
            saas_acceptance_resources.SaasBasesearchCheckStatusScript,
            saas_acceptance_resources.SaasBasesearchLoopConfig,
        )


__Task__ = ImagesBuildSaasAcceptanceBinariesAndConfigs
