from sandbox import sdk2

images_saas_acceptance_releasers = [
    'ulgen4a',
    'sakhnov',
    'anskor',
    'panovav',
    'mseifullin',
    'robot-images-sandbox',
]

images_saas_acceptance_subscribers = images_saas_acceptance_releasers


class SaasAcceptanceResource(sdk2.Resource):
    auto_backup = True
    releasers = images_saas_acceptance_releasers
    release_subscribers = images_saas_acceptance_subscribers


class SaasDetachedIndexShardMap(SaasAcceptanceResource):
    """
        Resource that stores handcrafted shard map (shardid->rbtorrent) for detached index
    """
    releasable = False
    share = True


class SaasIndexerproxyCheckStatusScript(SaasAcceptanceResource):
    """
        Check status script for indexerproxy(acceptance) that stored in the arcadia
    """
    arcadia_path = 'extsearch/images/saas/saas_acceptance/indexerproxy/deployment/configs/indexerproxy_check_status.sh'


class SaasIndexerproxyBackupSearchmap(SaasAcceptanceResource):
    """
        Backup search map for indexerproxy(acceptance) that stored in the arcadia
    """
    arcadia_path = 'extsearch/images/saas/saas_acceptance/indexerproxy/deployment/configs/indexerproxy_searchmap.json_backup'


class SaasBasesearchCheckStatusScript(SaasAcceptanceResource):
    """
        Check status script for basesearch(acceptance) that stored in the arcadia
    """
    arcadia_path = 'extsearch/images/saas/saas_acceptance/basesearch/deployment/configs/basesearch_check_status.sh'


class SaasBasesearchLoopConfig(SaasAcceptanceResource):
    """
        Loop config for basesearch(acceptance)
    """
    arcadia_path = 'extsearch/images/saas/saas_acceptance/basesearch/deployment/configs/basesearch_loop.conf'


class SaasBasesearchDownloadBackupShardScript(SaasAcceptanceResource):
    """
        Binary that downloads shard that was backuped from prod
    """
    arcadia_build_path = 'extsearch/images/saas/saas_acceptance/basesearch/deployment/download_backup_shard'
