import logging
import os.path
import shutil

from sandbox.sandboxsdk import paths
from sandbox.sandboxsdk import process

from sandbox.projects import resource_types


class SysinfoTask:
    """
        Mixin to store some system information

        Can be useful to debug performance issues in tasks
    """

    def _dump_sysinfo(self):
        sysinfo_dir = self.abs_path('sysinfo')
        paths.make_folder(sysinfo_dir, delete_content=True)

        for src_path in ("/proc/cpuinfo", "/proc/meminfo", "/proc/mounts"):
            if not os.path.exists(src_path):
                continue
            dst_path = os.path.join(sysinfo_dir, os.path.basename(src_path))
            with open(dst_path, "w") as dst_file:
                with open(src_path) as src_file:
                    shutil.copyfileobj(src_file, dst_file)

        for cmd in (["df"], ["ps", "uaxfww"]):
            with open(os.path.join(sysinfo_dir, "{}.stdout".format(cmd[0])), "w") as stdout_file:
                with open(os.path.join(sysinfo_dir, "{}.stderr".format(cmd[0])), "w") as stderr_file:
                    proc = process.run_process(cmd, stdout=stdout_file, stderr=stderr_file, wait=False)
                    rc = proc.wait()
                    logging.info("Exit code for {} is {}".format(cmd, rc))

        res = self.create_resource("{}, sysinfo".format(self.descr), sysinfo_dir, resource_types.OTHER_RESOURCE)
        self.mark_resource_ready(res.id)
