# -*- coding: utf-8 -*-

import logging
import os
from sandbox import sdk2

from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.WizardRuntimeBuild.ya_make import YaMake

YaMake = YaMake.YaMake


class ImagesTagsUpdateBansWizardData(sdk2.Task):
    """
    Update resource IDs in ya.make for ImgTagsBan begemot rule.
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1 * 1024  # 1 Gb
        ram = 1 * 1024  # 1 Gb
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        ArcadiaDataPath = sdk2.parameters.String(
            'Arcadia data path',
            default=Arcadia.trunk_url('search/wizard/data/fresh/ImgTagsBan')
        )
        ResourceIds = sdk2.parameters.Dict(
            'Files with their resource ids',
            required=True,
        )
        CommitMessage = sdk2.parameters.String(
            'Commit message',
            required=True,
        )

    def on_execute(self):

        wizard_data_path = str(self.path("wizard_data"))
        Arcadia.checkout(self.Parameters.ArcadiaDataPath, wizard_data_path)

        yamakefile = os.path.join(wizard_data_path, 'ya.make')
        yamake = YaMake(yamakefile)
        for filename, resource_id in self.Parameters.ResourceIds.iteritems():
            yamake.update_sandbox_resource(str(filename), resource_id, compression='FILE')
        with open(yamakefile, 'w') as y:
            yamake.dump(y)

        svn_status = Arcadia.status(wizard_data_path)
        if svn_status:
            Arcadia.commit(wizard_data_path, self.Parameters.CommitMessage, 'zomb-sandbox-rw')
        else:
            logging.info("No diff found")
