from sandbox.projects.images.bans.resources import BanResource, ToolResource

cv_releasers = ['rakhunzy', 'robot-cvtags', 'robot-similar', 'woxalex', 'elenabondar', 'klakhman', 'ladaev', 'matsuk', 'vadikrobot', 'polushkin', 'volynkin', 'fedorets']
alisa_releasers = []


class IMAGES_TAGS_BAN_COMPILER_EXECUTABLE(ToolResource):
    """
        Utility to compile tag bans.
    """
    releasers = cv_releasers + alisa_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/tags/tools/ban_compiler/tags_ban_compiler'


class IMAGES_TAGS_BAN_GZT(BanResource):
    """
        Binary gazetteer with tags banned to display.
    """
    releasers = cv_releasers + alisa_releasers
    basename = 'banned-tags.gzt.bin'


class IMAGES_TAGS_BAN_PIRE(BanResource):
    """
        Compiled regular expressions that forbidden to display as tags.
    """
    releasers = cv_releasers + alisa_releasers
    basename = 'banned-tags.pire.bin'
