# -*- coding: utf-8 -*-

from sandbox.projects.images.thumbrella import resources as thumbrella_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class ImagesBuildThumbrellaViewer(BaseMediaBuildTask):
    """
        Thumbrella viewer
    """

    type = "IMAGES_BUILD_THUMBRELLA_VIEWER"

    def get_binaries(self):
        return (
            thumbrella_resources.IMAGES_THUMBRELLA_EXECUTABLE,
            thumbrella_resources.IMAGES_THUMBRELLA_VIEWER_EXECUTABLE,
        )

    def get_configs(self):
        return (
            thumbrella_resources.IMAGES_THUMBRELLA_VIEWER_STATIC,
            thumbrella_resources.IMAGES_THUMBRELLA_VIEWER_TEMPLATES,
            thumbrella_resources.IMAGES_THUMBRELLA_VIEWER_CONFIG,
        )


__Task__ = ImagesBuildThumbrellaViewer
