from sandbox import sdk2
from sandbox.projects.resource_types import images_index_releasers, images_index_subscribers


class ImagesThumbrellaResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_index_subscribers


class IMAGES_THUMBRELLA_EXECUTABLE(ImagesThumbrellaResource):
    """
       Thumbrella executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/thumbrella/main/thumbrella'


class IMAGES_THUMBRELLA_VIEWER_EXECUTABLE(ImagesThumbrellaResource):
    """
       Thumbrella viewer executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/thumbrella/viewer/thumbrella_viewer'


class IMAGES_THUMBRELLA_VIEWER_TEMPLATES(ImagesThumbrellaResource):
    """
        Jinja2 templates for thumbrella viewer
    """
    arcadia_path = 'extsearch/images/robot/thumbrella/viewer/templates'


class IMAGES_THUMBRELLA_VIEWER_STATIC(ImagesThumbrellaResource):
    """
       Static resources for thumbrella viewer
    """
    arcadia_path = 'extsearch/images/robot/thumbrella/viewer/static'


class IMAGES_THUMBRELLA_VIEWER_CONFIG(ImagesThumbrellaResource):
    """
       Configuration file for thumbrella viewer
    """
    arcadia_path = 'extsearch/images/robot/thumbrella/viewer/config/config.json'


class IMAGES_THUMBRELLA_SYNC_EXECUTABLE(ImagesThumbrellaResource):
    """
       Backup tool executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/thumbrella/tools/sync/thumbrella-sync'
