# coding: utf-8

import os
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common.build import YaPackage
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import auto_deploy
from sandbox.projects.images.ultradaemon.resources import IMAGES_ULTRADAEMON_LOOP_CONFIG


class ImagesPackageParameter(YaPackage.PackagesParameter):
    default_value = 'extsearch/images/robot/packages/ultra.json'


class ImagesPackageTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = 'IMAGES_ULTRA_PACKAGE'


class StripBinariesParameter(YaPackage.StripBinariesParameter):
    default_value = True


class ImagesBuildUltraPackage(YaPackage.YaPackage, auto_deploy.AutoNannyDeployTask):
    type = 'IMAGES_BUILD_ULTRA_PACKAGE'

    __STABLE_SERVICES = ['production_man_ultrad', 'production_sas_ultrad']
    __TESTING_SERVICES = ['acceptance_man_ultrad']

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        ImagesPackageParameter,
        ImagesPackageTypeParameter,
        build_params.ArcadiaPatch,
        StripBinariesParameter,
    )

    execution_space = 30 * 1024

    def on_execute(self):
        self.__create_loop_conf()
        YaPackage.YaPackage.on_execute(self)

    def on_enqueue(self):
        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})
        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        YaPackage.YaPackage.on_release(self, additional_parameters)
        auto_deploy.AutoNannyDeployTask.on_release(self, additional_parameters)

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES

    def __create_loop_conf(self):
        resource_id = self.create_resource(
            "Images ultradaemon loop.conf", 'loop.conf',
            IMAGES_ULTRADAEMON_LOOP_CONFIG,
        ).id
        resource = channel.sandbox.get_resource(resource_id)
        arcadia_root = self.ctx[parameters.SandboxArcadiaUrlParameter.name]
        arcadia_path = IMAGES_ULTRADAEMON_LOOP_CONFIG.arcadia_path
        arcadia_url = os.path.join(arcadia_root, arcadia_path)
        Arcadia.export(arcadia_url, resource.path)
        channel.task.mark_resource_ready(resource)


__Task__ = ImagesBuildUltraPackage
