# -*- coding: utf-8 -*-

from sandbox.projects.images.upbase import resources as upbase_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class ImagesBuildUpbaseResources(BaseMediaBuildTask):
    """
       Resources for upbase
    """

    type = 'IMAGES_BUILD_UPBASE_RESOURCES'

    def get_binaries(self):
        return (
            upbase_resources.IMAGES_UPBASE_RUNNER_EXECUTABLE,
            upbase_resources.IMAGES_UPBASE_QUEUE_EXECUTABLE,
        )

    def get_configs(self):
       return (
            upbase_resources.IMAGES_UPBASE_CONFIG_TEMPLATES,
        )


__Task__ = ImagesBuildUpbaseResources
