from sandbox import sdk2

images_upbase_releasers = [
    'igorluk',
    'ulgen4a',
    'robot-images-sandbox',
]

images_upbase_subscribers = ['igorluk']


class ImagesUpbaseResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = images_upbase_releasers
    release_subscribers = images_upbase_subscribers


class IMAGES_UPBASE_RUNNER_EXECUTABLE(ImagesUpbaseResource):
    """
       Upbase runner
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/upbase/upbase_v1/runner/upbase_runner'


class IMAGES_UPBASE_QUEUE_EXECUTABLE(ImagesUpbaseResource):
    """
       Upbase queue manager
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/upbase/upbase_v1/upbase_queue/upbase_queue'


class IMAGES_UPBASE_CONFIG_TEMPLATES(ImagesUpbaseResource):
    """
       Upbase config template for upbase
    """
    arcadia_path = 'extsearch/images/robot/upbase/upbase_v1/lib/upbase_lib/config_templates'


class IMAGES_UPBASE_VIEWER_EXECUTABLE(ImagesUpbaseResource):
    """
       Upbase viewer
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/upbase/upbase_v1/viewer/viewer'


class IMAGES_UPBASE_VIEWER_TEMPLATES(ImagesUpbaseResource):
    """
        Upbase viewer templates
    """
    arcadia_path = 'extsearch/images/robot/upbase/upbase_v1/viewer/templates'


class IMAGES_UPBASE_VIEWER_CONFIG(ImagesUpbaseResource):
    """
        Upbase viewer config
    """
    arcadia_path = 'extsearch/images/robot/upbase/upbase_v1/viewer/config/config.yaml'
