# coding: utf-8
import re
from urlparse import urljoin


def normalize_arcadia_url(arcadia_url, target):
    parts = arcadia_url.rsplit('#', 1)
    revision_re = re.compile(r'^[\da-zA-Z]{40}$')
    revision = ''
    if len(parts) == 2 and revision_re.match(parts[1]):
        revision = parts[1]

    if target[0] == '/':
        target = target[1:]
    if target.startswith('arc/trunk/arcadia/'):
        target = target[18:]
    if target.startswith('arc_vcs/'):
        target = target[8:]

    arcadia_url = urljoin('svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/', target)

    return arcadia_url, revision
