# coding: utf-8
from requests import get, post


class Impulse(object):
    base_url = ''
    token = ''

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.token = token
        self.headers = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth ' + self.token
            }

    def get_task_id(self, organization_id, project_id, parameters, analysers, sandbox_task_id):
        data = {
            'organization_id': organization_id,
            'project_id': project_id,
            'parameters': parameters,
            'analysers': analysers,
            'sandbox_task_id': sandbox_task_id,
        }
        url = self.base_url + '/control/tasks_sandbox'
        r = post(url, json=data, headers=self.headers)
        if r.status_code != 200:
            return None

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']['id']
        return None

    def get_scan_instances(self, task_id):
        url = self.base_url + '/storage/tasks/{}/scanInstances'.format(task_id)
        r = get(url, headers=self.headers)
        if r.status_code != 200:
            return None

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']
        return None
