# coding: utf-8
import os
import logging
# import tempfile
import uuid

from sandbox import sdk2
# from sandbox.sdk2.helpers import subprocess as sp
# from sandbox.sdk2.helpers import ProcessLog

from sandbox.projects.impulse.BuildCodeQLQueries import utils
from sandbox.projects.impulse.SastWorkflow.checkout import CheckoutOperation


class CodeQL:
    def __init__(self, codeql_home="/usr/local/bin/codeql"):
        self.codeql_home = codeql_home
        self.codeql_cli_folder_name = "codeql-cli"
        self.codeql_cli_folder_path= os.path.join(self.codeql_home, self.codeql_cli_folder_name)
        self.codeql_cli_path = os.path.join(self.codeql_cli_folder_path, "codeql")
        self.codeql_queries_folder_name = "codeql-queries"
        self.codeql_queries_folder_path = os.path.join(self.codeql_home, self.codeql_queries_folder_name)
        self.codeql_go_queries_folder_name = "codeql-go-queries"
        self.codeql_go_queries_folder_path = os.path.join(self.codeql_home, self.codeql_go_queries_folder_name)
        # self.codeql_yandex_queries_folder_name = "codeql-yandex-queries"
        # self.codeql_yandex_queries_folder_path = os.path.join(self.codeql_home, self.codeql_yandex_queries_folder_name)

    def _compile_qls(self, qls):
        logging.debug("[+] _compile_qls. qls: {}".format(qls))
        # cmd = [self.codeql_cli_path, "query", "compile", "--search-path", self.codeql_yandex_queries_folder_path, qls]
        cmd = [self.codeql_cli_path, "query", "compile", "--additional-packs", self.codeql_home, qls]
        logfile = "_".join(["query", "compile", qls])
        return utils.execute(cmd, logfile=logfile)

    def compile_queries(self, qls_list):
        logging.debug("[+] compile_queries. qls_list: {}".format(qls_list))
        for qls in qls_list:
            self._compile_qls(qls)

    def _prepare_codeql_folder(self, url, dst):

        filename = "{}.zip".format(str(uuid.uuid4()))
        filepath = os.path.join(self.codeql_home, filename)
        utils.download_file(url, filepath)

        old_files = os.listdir(self.codeql_home)

        logging.debug("[+] _prepare_codeql_folder. old_files: {}".format(old_files))

        rc = utils.execute_unzip(filepath, self.codeql_home)
        if rc:
            raise Exception("[+] error in execute_unzip from '{}' to '{}'.".format(filepath, self.codeql_home))

        new_files = os.listdir(self.codeql_home)
        logging.debug("[+] _prepare_codeql_folder. new_files: {}".format(new_files))
        new_folder = list(set(new_files).difference(set(old_files)))[0]

        src = os.path.join(self.codeql_home, new_folder)
        ret_code = utils.execute_mv(src, dst)
        if rc:
            raise Exception("[+] error in execute_mv from '{}' to '{}'.".format(src, dst))
        return ret_code

    # def _prepare_custom_codeql_queries(self, src, dst):

    #     logfile = "_".join(["mv", src, dst])
    #     rc = utils.execute_mv(src, dst, lofgile=logfile)
    #     if rc:
    #         raise Exception("[+] error in execute_mv from '{}' to '{}'.".format(src, dst))
    #     return rc

    def _prepare_codeql_repos(self, repo_and_folder):
        repositories = list()
        for repo in repo_and_folder.keys():
            repositories.append({"url": repo})
        c = CheckoutOperation(repositories)
        # with sdk2.ssh.Key(self, key_owner='BUILD_CODEQL_INDEX_SSH_KEY'):
        with sdk2.ssh.Key(self, key_owner='IMPULSE_SSH_KEY'):
            c.checkout()
        for project_path in c.folders.keys():
            repo = c.folders[project_path]["repository"]
            target_path = repo_and_folder[repo]
            utils.execute_mv(project_path, target_path)

    # def prepare_env(self, codeql_cli_url=None, codeql_queries_url=None, codeql_go_queries_url=None, codeql_yandex_queries_url=None):
    def prepare_env(self, codeql_cli_url=None, codeql_queries_url=None, codeql_go_queries_url=None):
        logging.debug("[+] preparing for codeql-cli")
        ret_code = self._prepare_codeql_folder(codeql_cli_url, self.codeql_cli_folder_path)
        if ret_code:
            raise Exception("[+] error on _prepare_codeql_folder for  codeql-cli")

        logging.debug("[+] preparing for codeql repos")

        repo_and_folder = dict()
        if "bb.yandex-team.ru" in codeql_queries_url:
            repo_and_folder[codeql_queries_url] = self.codeql_queries_folder_path
        if "bb.yandex-team.ru" in codeql_go_queries_url:
            repo_and_folder[codeql_go_queries_url] = self.codeql_go_queries_folder_path
        if len(repo_and_folder) > 0:
            self._prepare_codeql_repos(repo_and_folder)

        if "bb.yandex-team.ru" not in codeql_queries_url:
            logging.debug("[+] preparing for codeql-queries")
            ret_code = self._prepare_codeql_folder(codeql_queries_url, self.codeql_queries_folder_path)
            if ret_code:
                raise Exception("[+] error on _prepare_codeql_folder for codeql-queries")

        if "bb.yandex-team.ru" not in codeql_go_queries_url:
            logging.debug("[+] preparing for codeql-go-queries")
            ret_code = self._prepare_codeql_folder(codeql_go_queries_url, self.codeql_go_queries_folder_path)
            if ret_code:
                raise Exception("[+] error on _prepare_codeql_folder for codeql-go-queries")

        # logging.debug("[+] preparing for codeql-yandex-queries")
        # ret_code = self._prepare_codeql_folder(codeql_yandex_queries_url, self.codeql_yandex_queries_folder_path)
        # if ret_code:
            # raise Exception("[+] error on _prepare_custom_codeql_queries")

        # logging.debug("[+] preparing for codeql-yandex-queries")
        # ret_code = self._prepare_custom_codeql_queries(codeql_yandex_queries_folder, self.codeql_yandex_queries_folder_path)
        # if ret_code:
        #     raise Exception("[+] error on _prepare_custom_codeql_queries")

        return None
