
import os
# import tempfile
import logging
import requests

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sdk2.helpers import ProcessLog


DEFAULT_EXCUTE_LOGFILE = "execute-logfile"


def execute(cmd, logfile=DEFAULT_EXCUTE_LOGFILE):
    logging.debug("[+] Execute cmd: '{}'. with logfile: '{}'.".format(cmd, logfile))
    with ProcessLog(sdk2.Task.current, logger=logfile) as pl:
        ret_code = sp.Popen(cmd, stdout=pl.stdout, stderr=pl.stderr).wait()
    return ret_code


def execute_unzip(source, dest, logfile=DEFAULT_EXCUTE_LOGFILE):
    cmd = ["unzip", source, "-d", dest]
    return execute(cmd, logfile=logfile)


def execute_mv(source, dest, logfile=DEFAULT_EXCUTE_LOGFILE):
    cmd = ["mv", source, dest]
    return execute(cmd, logfile=logfile)


def download_file(url, dest):
    logging.debug("[+] Downloading file from url: '{}'. Saving to file '{}'.".format(url , dest))
    r = requests.get(url, allow_redirects=True)
    f = open(dest, "wb")
    f.write(r.content)
    f.close()
    return


def create_tarball(path, dest, logfile=DEFAULT_EXCUTE_LOGFILE):
    folder, file = os.path.split(os.path.normpath(path))
    cmd = ["tar", "czvf", dest, "-C", folder, file]
    return execute(cmd, logfile=logfile)
