LANGPREFS = {
    'Python': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan",
            "codeql_scan"
        ],
        "parameters": {
            "config_paths": [
                "python",
            ],
            "codeql_lang": "python",
            "codeql_qls": "python-arcanum.qls",
        },
        "exts": ["py"],
    },
    'C++': {
        "analyzers": [
            "codeql_scan"
        ],
        "parameters": {
            "codeql_lang": "cpp",
            "codeql_qls": "cpp-arcanum.qls",
        },
        "exts": ["cpp", "hpp"],
    },
    'C': {
        "analyzers": [
            "semgrep_scan"
        ],
        "parameters": {
            "config_paths": [
                "c",
            ],
        },
        "exts": ["c", "h"],
    },
    'JavaScript': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan",
            "codeql_scan"
        ],
        "parameters": {
            "config_paths": [
                "javascript",
            ],
            "codeql_lang": "javascript",
            "codeql_qls": "javascript-arcanum.qls",
        },
        "exts": ["js"],
    },
    'TypeScript': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan",
            "codeql_scan"
        ],
        "parameters": {
            "config_paths": [
                "typescript",
            ],
            "codeql_lang": "javascript",
            "codeql_qls": "javascript-arcanum.qls",
        },
        "exts": ["ts"],
    },
    'Go': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan",
            "codeql_scan",
            "gosec_scan"
        ],
        "parameters": {
            "config_paths": [
                "go",
            ],
            "codeql_lang": "go",
            "codeql_qls": "go-arcanum.qls",
        },
        "exts": ["go"],
    },
    'Java': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan",
            "codeql_scan",
        ],
        "parameters": {
            "config_paths": [
                "java",
            ],
            "codeql_lang": "java",
            "codeql_qls": "java-arcanum.qls",
        },
        "exts": ["java"],
    },
    'PHP': {
        "analyzers": [
            "semgrep_scan"
        ],
        "parameters": {
            "config_paths": [
                "php",
            ],
        },
        "exts": ["php"],
    },
    'Makefile': {
        "exts": ["makefile"],
    },
    'Scala': {
        "analyzers": [
            "semgrep_scan",
            "yadi_scan"
        ],
        "parameters": {
            "config_paths": [
                "scala",
            ],
        },
        "exts": ["scala"],
    }
}


def ext2lang(ext):
    return {ext: lang for lang, prefs in LANGPREFS.iteritems() for ext in prefs.get('exts', [])}.get(ext.lower())


def langs2analyzers(langs):
    return list({analyzer for lang, prefs in LANGPREFS.iteritems() if lang in langs for analyzer in prefs.get('analyzers', [])})


def langs2scanparams(langs):
    config_paths = set()
    codeql_langs = set()
    codeql_qlss = set()
    for params in (prefs.get('parameters', {}) for lang, prefs in LANGPREFS.iteritems() if lang in langs):
        config_paths.update(params.get('config_paths', []))
        if params.get('codeql_lang', False):
            codeql_langs.add(params.get('codeql_lang'))
        if params.get('codeql_qls', False):
            codeql_qlss.add(params.get('codeql_qls'))
    return {
        "config_paths": list(config_paths),
        "codeql_lang": ",".join(codeql_langs),
        "codeql_qlss": ",".join(codeql_qlss),
    }
