# coding: utf-8
from requests import get, post, put, delete


class Impulse(object):
    base_url = ''
    token = ''

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.token = token
        self.headers = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth ' + self.token
        }

    def get_projects(self, organization_id):
        url = self.base_url + '/storage/organizations/{}/projects'.format(organization_id)
        r = get(url, headers=self.headers)

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']
        return None

    def create_project(self, organization_id, name, slug, tags=[]):
        url = self.base_url + '/storage/organizations/{}/projects'.format(organization_id)
        params = {
            "name": name,
            "slug": slug,
            "tags": tags,
        }
        r = post(url, headers=self.headers, json=params)

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']
        return None

    def delete_project(self, organization_id, project_id):
        url = self.base_url + '/storage/organizations/{}/projects/{}'.format(organization_id, project_id)
        r = delete(url, headers=self.headers)

        json_data = r.json()
        return json_data['ok']

    def update_project(self, organization_id, project_id,
                       name=None, tags=None, tracker_queue=None, abc_service_id=None):
        url = self.base_url + '/storage/organizations/{}/projects/{}'.format(organization_id, project_id)
        params = {}
        if name:
            params['name'] = name
        if tags:
            params['tags'] = tags
        if tracker_queue:
            params['tracker_queue'] = tracker_queue
        if abc_service_id:
            params['abc_service_id'] = abc_service_id
        r = put(url, headers=self.headers, json=params)

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']
        return None

    def create_scan(self, organization_id, project_id, analysers, parameters, callback_url=""):
        url = self.base_url + '/control/tasks'
        params = {
            "organization_id": organization_id,
            "project_id": project_id,
            "parameters": parameters,
            "analysers": analysers,
            "callback_url": callback_url,
        }
        r = post(url, headers=self.headers, json=params)

        json_data = r.json()
        if json_data['ok']:
            return json_data['result']
        return None
