import os
import stat

import sandbox.common.types.resource as ctr
from sandbox import sdk2


def get_last_released_resource(resource_type, attrs={}):
    return resource_type.find(
        attrs=attrs or {},
        state=ctr.State.READY,
        arch="linux"
    ).order(-sdk2.Resource.id).first()


def download_resource(resource):
    return sdk2.ResourceData(resource).path.as_posix()


def chmod_x(path):
    st = os.stat(path)
    os.chmod(path, st.st_mode | stat.S_IEXEC)
