PY2_LIBRARY()

OWNER(
    kaleda
    g:security
)

PY_SRCS(
    SastWorkflow/__init__.py
    SastWorkflow/checkout.py
    SastWorkflow/operation.py
    SastWorkflow/helpers.py
    ArcadiaSast/__init__.py
    ArcadiaSast/impulse.py
    ArcadiaSast/helpers.py
    BuildCodeQLIndex/__init__.py
    BuildCodeQLIndex/codeql.py
    BuildCodeQLQueries/__init__.py
    BuildCodeQLQueries/codeql.py
    BuildCodeQLQueries/queries_s3_cacher.py
    BuildCodeQLQueries/utils.py
    ProjectsCollector/__init__.py
    ProjectsCollector/arcadia.py
    ProjectsCollector/bitbucket.py
    ProjectsCollector/common.py
    ProjectsCollector/impulse.py
    ProjectsCollector/insights.py
    ProjectsCollector/github.py
)

SET(PWD "sandbox/projects/impulse")
PEERDIR(
    ${PWD}/SastWorkflow
    ${PWD}/ArcadiaSast
    ${PWD}/BuildCodeQLIndex
    ${PWD}/BuildCodeQLQueries
    ${PWD}/ProjectsCollector
)

RESOURCE(
    SastWorkflow/manifest/bandit.json sandbox/projects/impulse/SastWorkflow/manifest/bandit.json
    SastWorkflow/manifest/blackduck.json sandbox/projects/impulse/SastWorkflow/manifest/blackduck.json
    SastWorkflow/manifest/codeql.json sandbox/projects/impulse/SastWorkflow/manifest/codeql.json
    SastWorkflow/manifest/eslint.json sandbox/projects/impulse/SastWorkflow/manifest/eslint.json
    SastWorkflow/manifest/gosec.json sandbox/projects/impulse/SastWorkflow/manifest/gosec.json
    SastWorkflow/manifest/semgrep.json sandbox/projects/impulse/SastWorkflow/manifest/semgrep.json
    SastWorkflow/manifest/rips.json sandbox/projects/impulse/SastWorkflow/manifest/rips.json
    SastWorkflow/manifest/yadi.json sandbox/projects/impulse/SastWorkflow/manifest/yadi.json
    SastWorkflow/manifest/yodax.json sandbox/projects/impulse/SastWorkflow/manifest/yodax.json
)

END()

RECURSE(
    SastWorkflow
    ArcadiaSast
    BuildCodeQLIndex
    BuildCodeQLQueries
    ProjectsCollector
)
