import requests

from sandbox import sdk2


class ReachableFileByUrlTest(sdk2.Task):
    """
        Checks accessibility of file by url
    """

    class Parameters(sdk2.Task.Parameters):
        url = sdk2.parameters.String("Url of file", required=True)
        auth_token = sdk2.parameters.String("Secret name from vault", default=None, required=False)

    def on_execute(self):
        headers = {}
        if self.Parameters.auth_token:
            headers = {"Authorization": "OAuth {}".format(sdk2.Vault.data(self.Parameters.owner, self.Parameters.auth_token))}

        response = requests.get(self.Parameters.url, headers=headers)

        http_code = response.status_code
        if (http_code != 200):
            raise ValueError("Bad http response code: {}".format(http_code))

        if not response.content:
            raise ValueError("File content is empty")
