import logging

from sandbox.projects.common.arcadia import sdk
from sandbox.common import errors
from sandbox.sdk2 import svn


def get_arcadia(arcadia_url):
    try:
        if not sdk.fuse_available():
            raise errors.TaskFailure('Fuse unavailable')
        return sdk.mount_arc_path(arcadia_url)
    except errors.TaskFailure as e:
        logging.exception(e)
        return svn.Arcadia.get_arcadia_src_dir(arcadia_url)
