from sandbox import sdk2
from sandbox.projects.yp.common import YP_RELEASERS


class YP_CAUTH_EXPORT_PACKAGE(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = YP_RELEASERS


class YP_EXPORT_PACKAGE(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = YP_RELEASERS + ["robot-srch-releaser"]


class YP_EXPORT_SOURCES_CACHING_PROXY_PACKAGE(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = YP_RELEASERS
    arcadia_build_path = "yp/export/sources_caching_proxy"


class YP_IDM_ROLE_PROVIDER_PACKAGE(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = YP_RELEASERS


class RESOURCE_CACHE_CONTROLLER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = [
        "amich",
        "staroverovad",
        "dkochetov",
        "robot-srch-releaser",
    ]


class DEPLOY_MONITORING_CONTROLLER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = [
        "amich",
        "dkochetov",
        "robot-srch-releaser",
    ]


class HORIZONTAL_POD_AUTOSCALER_CONTROLLER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = [
        "amich",
        "dkochetov",
        "robot-srch-releaser",
    ]


class SERVICE_CONTROLLER_BINARY(sdk2.Resource):

    auto_backup = True
    releasable = True
    executable = True
    releasers = [
        "azuremint",
        "dima-zakharov",
        "elshiko",
        "ismagilas",
        "robot-ci-srvc-ctrl",
    ]


class ALERT_CONTROLLER_LAYER(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["panefgen", "DRUG-RELEASERS"]


class DEPLOY_DOCTOR_LAYER(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["panefgen", "DRUG-RELEASERS"]


class SIDECARS_UPDATER_LAYER(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["amich", "panefgen", "DRUG-RELEASERS"]


class SBR_UPDATER_LAYER(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["amich", "panefgen", "DRUG-RELEASERS"]


class STAGE_CONTROLLER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["dkochetov", "reddi", "alonger", "amich", "crastin", "panefgen", "slamur", "staroverovad", "vonzeppelin", "robot-srch-releaser"]


class AUTH_CONTROLLER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = ["staroverovad", "amich", "vonzeppelin", "robot-srch-releaser"]


class PodAgentBinary(sdk2.Resource):
    """
        stripped pod_agent binary (from infra/pod_agent/daemons/pod_agent)
        Built in pair with PodAgentBinaryWithDebugInfo
    """

    executable = True
    releasable = True
    releasers = [
        "amich",
        "dkochetov",
        "staroverovad",
        "robot-srch-releaser",
    ]
    auto_backup = True
    sync_upload_to_mds = True

    arcadia_build_path = "infra/pod_agent/daemons/pod_agent/pod_agent"
    size_limit = 100 * (1 << 20)  # 100 MB

    released_sas_test = sdk2.parameters.Bool("Released on sas_test", default_value=False)
    released_man_pre = sdk2.parameters.Bool("Released on man_pre", default_value=False)
    released_xdc_acceptance = sdk2.parameters.Bool("Released on xdc acceptance", default_value=False)
    released_xdc = sdk2.parameters.Bool("Released on xdc", default_value=False)


class PodAgentBinaryWithDebugInfo(sdk2.Resource):
    """
        pod_agent binary with debug symbols (from infra/pod_agent/daemons/pod_agent)
        Built in pair with PodAgentBinary
    """

    executable = True
    releasable = True
    releasers = [
        "amich",
        "dkochetov",
        "staroverovad",
        "robot-srch-releaser",
    ]
    auto_backup = True
    sync_upload_to_mds = True

    arcadia_build_path = "infra/pod_agent/daemons/pod_agent/pod_agent"

    released_sas_test = sdk2.parameters.Bool("Released on sas_test", default_value=False)
    released_man_pre = sdk2.parameters.Bool("Released on man_pre", default_value=False)
    released_xdc_acceptance = sdk2.parameters.Bool("Released on xdc acceptance", default_value=False)
    released_xdc = sdk2.parameters.Bool("Released on xdc", default_value=False)


class PodAgentTestServiceLayer(sdk2.Resource):
    """
        pod_agent_test_service layer with binary (from infra/pod_agent/tools/stage_deploy/test_service)
    """

    releasable = True
    releasers = [
        "amich",
        "dkochetov",
        "robot-srch-releaser",
    ]
    auto_backup = True
    arcadia_build_path = "infra/pod_agent/tools/stage_deploy/test_service/test_service"


class EventlogUploader(sdk2.Resource):
    """
       script for upload eventlog to YT
    """

    releasable = True
    auto_backup = True


class EventlogUploaderBinary(sdk2.Resource):
    """
       Util for upload eventlog to YT
    """

    releasable = True
    auto_backup = True


class QemuTool(sdk2.Resource):
    """
       QEMU machine emulator and virtualizer
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["khlebnikov", "dmtrmonakhov", "frolstas"]
    tool_name = sdk2.parameters.String("Tool name")
    platform = sdk2.parameters.String("Resource platform")
    version = sdk2.parameters.String("Version")
    arcadia_build_path = 'infra/qemu/build/qemu.tar.gz'
